/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.kaha.impl;

import java.io.IOException;
import org.apache.activemq.kaha.Marshaller;
import org.apache.activemq.kaha.impl.DataFile;
import org.apache.activemq.kaha.impl.DataItem;
import org.apache.activemq.kaha.impl.DataManager;
import org.apache.activemq.kaha.impl.StoreByteArrayOutputStream;

final class StoreDataWriter {
    private StoreByteArrayOutputStream dataOut;
    private DataManager dataManager;

    StoreDataWriter(DataManager fileManager) {
        this.dataManager = fileManager;
        this.dataOut = new StoreByteArrayOutputStream();
    }

    DataItem storeItem(Marshaller marshaller, Object payload) throws IOException {
        this.dataOut.reset();
        this.dataOut.position(6);
        marshaller.writePayload(payload, this.dataOut);
        int size = this.dataOut.size();
        int payloadSize = size - 6;
        DataItem item = new DataItem();
        item.setSize(payloadSize);
        DataFile dataFile = this.dataManager.findSpaceForData(item);
        this.dataOut.reset();
        item.writeHeader(this.dataOut);
        dataFile.getRandomAccessFile().seek(item.getOffset());
        dataFile.getRandomAccessFile().write(this.dataOut.getData(), 0, size);
        dataFile.incrementLength(size);
        this.dataManager.addInterestInFile(dataFile);
        return item;
    }
}

