/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.management;

import javax.management.j2ee.statistics.Statistic;
import org.apache.activemq.management.Resettable;

public class StatisticImpl
implements Statistic,
Resettable {
    private String name;
    private String unit;
    private String description;
    private long startTime;
    private long lastSampleTime;

    public StatisticImpl(String name, String unit, String description) {
        this.name = name;
        this.unit = unit;
        this.description = description;
        this.lastSampleTime = this.startTime = System.currentTimeMillis();
    }

    public synchronized void reset() {
        this.lastSampleTime = this.startTime = System.currentTimeMillis();
    }

    protected synchronized void updateSampleTime() {
        this.lastSampleTime = System.currentTimeMillis();
    }

    public synchronized String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.name);
        buffer.append("{");
        this.appendFieldDescription(buffer);
        buffer.append(" }");
        return buffer.toString();
    }

    public String getName() {
        return this.name;
    }

    public String getUnit() {
        return this.unit;
    }

    public String getDescription() {
        return this.description;
    }

    public synchronized long getStartTime() {
        return this.startTime;
    }

    public synchronized long getLastSampleTime() {
        return this.lastSampleTime;
    }

    protected synchronized void appendFieldDescription(StringBuffer buffer) {
        buffer.append(" unit: ");
        buffer.append(this.unit);
        buffer.append(" startTime: ");
        buffer.append(this.startTime);
        buffer.append(" lastSampleTime: ");
        buffer.append(this.lastSampleTime);
        buffer.append(" description: ");
        buffer.append(this.description);
    }
}

