/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.kahadaptor;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicInteger;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.SubscriptionInfo;
import org.apache.activemq.kaha.ListContainer;
import org.apache.activemq.kaha.MapContainer;
import org.apache.activemq.kaha.Store;
import org.apache.activemq.kaha.StringMarshaller;
import org.apache.activemq.store.MessageRecoveryListener;
import org.apache.activemq.store.TopicMessageStore;
import org.apache.activemq.store.kahadaptor.KahaMessageStore;

public class KahaTopicMessageStore
extends KahaMessageStore
implements TopicMessageStore {
    private Map ackContainer;
    private Map subscriberContainer;
    private Store store;
    private Map subscriberAcks = new ConcurrentHashMap();
    static /* synthetic */ Class class$java$lang$String;

    public KahaTopicMessageStore(Store store, MapContainer messageContainer, MapContainer ackContainer, MapContainer subsContainer, ActiveMQDestination destination) throws IOException {
        super(messageContainer, destination);
        this.store = store;
        this.ackContainer = ackContainer;
        this.subscriberContainer = subsContainer;
        Iterator i = this.subscriberContainer.keySet().iterator();
        while (i.hasNext()) {
            Object key = i.next();
            this.addSubscriberAckContainer(key);
        }
    }

    public synchronized void addMessage(ConnectionContext context, Message message) throws IOException {
        int subscriberCount = this.subscriberAcks.size();
        if (subscriberCount > 0) {
            String id = message.getMessageId().toString();
            this.ackContainer.put(id, new AtomicInteger(subscriberCount));
            Iterator i = this.subscriberAcks.keySet().iterator();
            while (i.hasNext()) {
                Object key = i.next();
                ListContainer container = this.store.getListContainer(key, "durable-subs");
                container.add(id);
            }
            super.addMessage(context, message);
        }
    }

    public synchronized void acknowledge(ConnectionContext context, String clientId, String subscriptionName, MessageId messageId) throws IOException {
        String subcriberId = this.getSubscriptionKey(clientId, subscriptionName);
        String id = messageId.toString();
        ListContainer container = (ListContainer)this.subscriberAcks.get(subcriberId);
        if (container != null) {
            container.removeFirst();
            AtomicInteger count = (AtomicInteger)this.ackContainer.remove(id);
            if (count != null) {
                if (count.decrementAndGet() > 0) {
                    this.ackContainer.put(id, count);
                } else {
                    super.removeMessage(messageId);
                }
            }
        }
    }

    public SubscriptionInfo lookupSubscription(String clientId, String subscriptionName) throws IOException {
        return (SubscriptionInfo)this.subscriberContainer.get(this.getSubscriptionKey(clientId, subscriptionName));
    }

    public synchronized void addSubsciption(String clientId, String subscriptionName, String selector, boolean retroactive) throws IOException {
        SubscriptionInfo info = new SubscriptionInfo();
        info.setDestination(this.destination);
        info.setClientId(clientId);
        info.setSelector(selector);
        info.setSubcriptionName(subscriptionName);
        String key = this.getSubscriptionKey(clientId, subscriptionName);
        if (!this.subscriberContainer.containsKey(key)) {
            this.subscriberContainer.put(key, info);
        }
        this.addSubscriberAckContainer(key);
    }

    public synchronized void deleteSubscription(String clientId, String subscriptionName) {
        String key = this.getSubscriptionKey(clientId, subscriptionName);
        this.subscriberContainer.remove(key);
        ListContainer list = (ListContainer)this.subscriberAcks.get(key);
        Iterator i = list.iterator();
        while (i.hasNext()) {
            String id = i.next().toString();
            AtomicInteger count = (AtomicInteger)this.ackContainer.remove(id);
            if (count == null) continue;
            if (count.decrementAndGet() > 0) {
                this.ackContainer.put(id, count);
                continue;
            }
            this.messageContainer.remove(id);
        }
    }

    public void recoverSubscription(String clientId, String subscriptionName, MessageRecoveryListener listener) throws Exception {
        String key = this.getSubscriptionKey(clientId, subscriptionName);
        ListContainer list = (ListContainer)this.subscriberAcks.get(key);
        if (list != null) {
            Iterator i = list.iterator();
            while (i.hasNext()) {
                Object msg = this.messageContainer.get(i.next());
                if (msg != null) {
                    if (msg.getClass() == (class$java$lang$String == null ? KahaTopicMessageStore.class$("java.lang.String") : class$java$lang$String)) {
                        listener.recoverMessageReference((String)msg);
                    } else {
                        listener.recoverMessage((Message)msg);
                    }
                }
                listener.finished();
            }
        } else {
            listener.finished();
        }
    }

    public void delete() {
        super.delete();
        this.ackContainer.clear();
        this.subscriberContainer.clear();
    }

    public SubscriptionInfo[] getAllSubscriptions() throws IOException {
        return this.subscriberContainer.values().toArray(new SubscriptionInfo[this.subscriberContainer.size()]);
    }

    protected String getSubscriptionKey(String clientId, String subscriberName) {
        String result = clientId + ":";
        result = result + (subscriberName != null ? subscriberName : "NOT_SET");
        return result;
    }

    protected void addSubscriberAckContainer(Object key) throws IOException {
        ListContainer container = this.store.getListContainer(key, "topic-subs");
        StringMarshaller marshaller = new StringMarshaller();
        container.setMarshaller(marshaller);
        this.subscriberAcks.put(key, container);
    }
}

