/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport;

import edu.emory.mathcs.backport.java.util.concurrent.ArrayBlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import java.io.IOException;
import java.io.InterruptedIOException;
import org.apache.activemq.command.Response;
import org.apache.activemq.transport.ResponseCallback;

public class FutureResponse {
    private final ResponseCallback responseCallback;
    private final ArrayBlockingQueue responseSlot = new ArrayBlockingQueue(1);

    public FutureResponse(ResponseCallback responseCallback) {
        this.responseCallback = responseCallback;
    }

    public Response getResult() throws IOException {
        try {
            return (Response)this.responseSlot.take();
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException("Interrupted.");
        }
    }

    public Response getResult(int timeout) throws IOException {
        try {
            return (Response)this.responseSlot.poll((long)timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException("Interrupted.");
        }
    }

    public void set(Response result) throws InterruptedIOException {
        try {
            this.responseSlot.put((Object)result);
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException("Interrupted.");
        }
        if (this.responseCallback != null) {
            this.responseCallback.onCompletion(this);
        }
    }
}

