/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.ExceptionResponse;
import org.apache.activemq.command.Response;
import org.apache.activemq.transport.FutureResponse;
import org.apache.activemq.transport.ResponseCallback;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportFilter;
import org.apache.activemq.util.IntSequenceGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResponseCorrelator
extends TransportFilter {
    private static final Log log = LogFactory.getLog((Class)ResponseCorrelator.class);
    private final ConcurrentHashMap requestMap = new ConcurrentHashMap();
    private IntSequenceGenerator sequenceGenerator;

    public ResponseCorrelator(Transport next) {
        this(next, new IntSequenceGenerator());
    }

    public ResponseCorrelator(Transport next, IntSequenceGenerator sequenceGenerator) {
        super(next);
        this.sequenceGenerator = sequenceGenerator;
    }

    public void oneway(Command command) throws IOException {
        command.setCommandId(this.sequenceGenerator.getNextSequenceId());
        command.setResponseRequired(false);
        this.next.oneway(command);
    }

    public FutureResponse asyncRequest(Command command, ResponseCallback responseCallback) throws IOException {
        command.setCommandId(this.sequenceGenerator.getNextSequenceId());
        command.setResponseRequired(true);
        FutureResponse future = new FutureResponse(responseCallback);
        this.requestMap.put((Object)new Integer(command.getCommandId()), (Object)future);
        this.next.oneway(command);
        return future;
    }

    public Response request(Command command) throws IOException {
        FutureResponse response = this.asyncRequest(command, null);
        return response.getResult();
    }

    public Response request(Command command, int timeout) throws IOException {
        FutureResponse response = this.asyncRequest(command, null);
        return response.getResult(timeout);
    }

    public void onCommand(Command command) {
        boolean debug = log.isDebugEnabled();
        if (command.isResponse()) {
            try {
                Response response = (Response)command;
                FutureResponse future = (FutureResponse)this.requestMap.remove((Object)new Integer(response.getCorrelationId()));
                if (future != null) {
                    future.set(response);
                } else if (debug) {
                    log.debug((Object)("Received unexpected response for command id: " + response.getCorrelationId()));
                }
            }
            catch (InterruptedIOException e) {
                this.onException(e);
            }
        } else {
            this.getTransportListener().onCommand(command);
        }
    }

    public void onException(IOException error) {
        ArrayList requests = new ArrayList(this.requestMap.values());
        this.requestMap.clear();
        Iterator iter = requests.iterator();
        while (iter.hasNext()) {
            try {
                FutureResponse fr = (FutureResponse)iter.next();
                fr.set(new ExceptionResponse(error));
            }
            catch (InterruptedIOException e) {
                Thread.currentThread().interrupt();
            }
        }
        super.onException(error);
    }

    public IntSequenceGenerator getSequenceGenerator() {
        return this.sequenceGenerator;
    }

    public String toString() {
        return this.next.toString();
    }
}

