/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport;

import java.io.IOException;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.RemoveInfo;
import org.apache.activemq.command.Response;
import org.apache.activemq.command.ShutdownInfo;
import org.apache.activemq.transport.FutureResponse;
import org.apache.activemq.transport.ResponseCallback;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportListener;
import org.apache.activemq.util.ServiceSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class TransportSupport
extends ServiceSupport
implements Transport {
    private static final Log log = LogFactory.getLog((Class)TransportSupport.class);
    TransportListener transportListener;

    public TransportListener getTransportListener() {
        return this.transportListener;
    }

    public void setTransportListener(TransportListener commandListener) {
        this.transportListener = commandListener;
    }

    public Object narrow(Class target) {
        boolean assignableFrom = target.isAssignableFrom(this.getClass());
        if (assignableFrom) {
            return this;
        }
        return null;
    }

    public FutureResponse asyncRequest(Command command, ResponseCallback responseCallback) throws IOException {
        throw new AssertionError((Object)"Unsupported Method");
    }

    public Response request(Command command) throws IOException {
        throw new AssertionError((Object)"Unsupported Method");
    }

    public Response request(Command command, int timeout) throws IOException {
        throw new AssertionError((Object)"Unsupported Method");
    }

    public void doConsume(Command command) {
        if (command != null) {
            if (this.transportListener != null) {
                this.transportListener.onCommand(command);
            } else {
                log.error((Object)("No transportListener available to process inbound command: " + command));
            }
        }
    }

    public void onException(IOException e) {
        if (this.transportListener != null) {
            this.transportListener.onException(e);
        }
    }

    protected void checkStarted(Command command) throws IOException {
        if (!(this.isStarted() || command instanceof ShutdownInfo || command instanceof RemoveInfo)) {
            throw new IOException("The transport " + this + " of type: " + this.getClass().getName() + " is not running.");
        }
    }
}

