/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.failover;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArrayList;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import org.apache.activemq.command.BrokerInfo;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.Response;
import org.apache.activemq.state.ConnectionStateTracker;
import org.apache.activemq.thread.DefaultThreadPools;
import org.apache.activemq.thread.Task;
import org.apache.activemq.thread.TaskRunner;
import org.apache.activemq.transport.CompositeTransport;
import org.apache.activemq.transport.FutureResponse;
import org.apache.activemq.transport.ResponseCallback;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportFactory;
import org.apache.activemq.transport.TransportListener;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.activemq.util.ServiceSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FailoverTransport
implements CompositeTransport {
    private static final Log log = LogFactory.getLog((Class)FailoverTransport.class);
    private TransportListener transportListener;
    private boolean disposed;
    private final CopyOnWriteArrayList uris = new CopyOnWriteArrayList();
    private final Object reconnectMutex = new Object();
    private final Object sleepMutex = new Object();
    private final ConnectionStateTracker stateTracker = new ConnectionStateTracker();
    private final ConcurrentHashMap requestMap = new ConcurrentHashMap();
    private URI connectedTransportURI;
    private Transport connectedTransport;
    private final TaskRunner reconnectTask;
    private boolean started;
    private long initialReconnectDelay = 10L;
    private long maxReconnectDelay = 30000L;
    private long backOffMultiplier = 2L;
    private boolean useExponentialBackOff = true;
    private boolean randomize = true;
    private boolean initialized;
    private int maxReconnectAttempts;
    private int connectFailures;
    private long reconnectDelay = this.initialReconnectDelay;
    private Exception connectionFailure;
    private final TransportListener myTransportListener = new TransportListener(){

        public void onCommand(Command command) {
            if (command == null) {
                return;
            }
            if (command.isResponse()) {
                FailoverTransport.this.requestMap.remove((Object)new Integer(((Response)command).getCorrelationId()));
            }
            if (!FailoverTransport.this.initialized && command.isBrokerInfo()) {
                BrokerInfo info = (BrokerInfo)command;
                BrokerInfo[] peers = info.getPeerBrokerInfos();
                if (peers != null) {
                    for (int i = 0; i < peers.length; ++i) {
                        String brokerString = peers[i].getBrokerURL();
                        FailoverTransport.this.add(brokerString);
                    }
                }
                FailoverTransport.this.initialized = true;
            }
            if (FailoverTransport.this.transportListener != null) {
                FailoverTransport.this.transportListener.onCommand(command);
            }
        }

        public void onException(IOException error) {
            try {
                FailoverTransport.this.handleTransportFailure(error);
            }
            catch (InterruptedException e) {
                FailoverTransport.this.transportListener.onException(new InterruptedIOException());
            }
        }

        public void transportInterupted() {
            if (FailoverTransport.this.transportListener != null) {
                FailoverTransport.this.transportListener.transportInterupted();
            }
        }

        public void transportResumed() {
            if (FailoverTransport.this.transportListener != null) {
                FailoverTransport.this.transportListener.transportResumed();
            }
        }
    };

    public FailoverTransport() throws InterruptedIOException {
        this.reconnectTask = DefaultThreadPools.getDefaultTaskRunnerFactory().createTaskRunner(new Task(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean iterate() {
                Exception failure = null;
                Object object = FailoverTransport.this.reconnectMutex;
                synchronized (object) {
                    if (FailoverTransport.this.disposed || FailoverTransport.this.connectionFailure != null) {
                        FailoverTransport.this.reconnectMutex.notifyAll();
                    }
                    if (FailoverTransport.this.connectedTransport != null || FailoverTransport.this.disposed || FailoverTransport.this.connectionFailure != null) {
                        return false;
                    }
                    ArrayList connectList = FailoverTransport.this.getConnectList();
                    if (connectList.isEmpty()) {
                        failure = new IOException("No uris available to connect to.");
                    } else {
                        if (!FailoverTransport.this.useExponentialBackOff) {
                            FailoverTransport.this.reconnectDelay = FailoverTransport.this.initialReconnectDelay;
                        }
                        Iterator iter = connectList.iterator();
                        int i = 0;
                        while (iter.hasNext() && FailoverTransport.this.connectedTransport == null && !FailoverTransport.this.disposed) {
                            URI uri = (URI)iter.next();
                            try {
                                log.debug((Object)("Attempting connect to: " + uri));
                                Transport t = TransportFactory.compositeConnect(uri);
                                t.setTransportListener(FailoverTransport.this.myTransportListener);
                                t.start();
                                if (FailoverTransport.this.started) {
                                    FailoverTransport.this.restoreTransport(t);
                                }
                                log.debug((Object)"Connection established");
                                FailoverTransport.this.reconnectDelay = FailoverTransport.this.initialReconnectDelay;
                                FailoverTransport.this.connectedTransportURI = uri;
                                FailoverTransport.this.connectedTransport = t;
                                FailoverTransport.this.reconnectMutex.notifyAll();
                                FailoverTransport.this.connectFailures = 0;
                                if (FailoverTransport.this.transportListener != null) {
                                    FailoverTransport.this.transportListener.transportResumed();
                                }
                                return false;
                            }
                            catch (Exception e) {
                                failure = e;
                                log.debug((Object)("Connect fail to: " + uri + ", reason: " + e));
                                ++i;
                            }
                        }
                    }
                    if (FailoverTransport.this.maxReconnectAttempts > 0 && ++FailoverTransport.this.connectFailures >= FailoverTransport.this.maxReconnectAttempts) {
                        log.error((Object)("Failed to connect to transport after: " + FailoverTransport.this.connectFailures + " attempt(s)"));
                        FailoverTransport.this.connectionFailure = failure;
                        FailoverTransport.this.reconnectMutex.notifyAll();
                        return false;
                    }
                }
                if (!FailoverTransport.this.disposed) {
                    log.debug((Object)("Waiting " + FailoverTransport.this.reconnectDelay + " ms before attempting connection. "));
                    object = FailoverTransport.this.sleepMutex;
                    synchronized (object) {
                        try {
                            FailoverTransport.this.sleepMutex.wait(FailoverTransport.this.reconnectDelay);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                    }
                    if (FailoverTransport.this.useExponentialBackOff) {
                        FailoverTransport.this.reconnectDelay *= FailoverTransport.this.backOffMultiplier;
                        if (FailoverTransport.this.reconnectDelay > FailoverTransport.this.maxReconnectDelay) {
                            FailoverTransport.this.reconnectDelay = FailoverTransport.this.maxReconnectDelay;
                        }
                    }
                }
                return !FailoverTransport.this.disposed;
            }
        }, "ActiveMQ Failover Worker: " + System.identityHashCode(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTransportFailure(IOException e) throws InterruptedException {
        if (this.transportListener != null) {
            this.transportListener.transportInterupted();
        }
        Object object = this.reconnectMutex;
        synchronized (object) {
            log.debug((Object)"Transport failed, starting up reconnect task", (Throwable)e);
            if (this.connectedTransport != null) {
                this.initialized = false;
                ServiceSupport.dispose(this.connectedTransport);
                this.connectedTransport = null;
                this.connectedTransportURI = null;
                this.reconnectTask.wakeup();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        Object object = this.reconnectMutex;
        synchronized (object) {
            log.debug((Object)"Started.");
            if (this.started) {
                return;
            }
            this.started = true;
            if (this.connectedTransport != null) {
                this.stateTracker.restore(this.connectedTransport);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws Exception {
        Object object = this.reconnectMutex;
        synchronized (object) {
            log.debug((Object)"Stopped.");
            if (!this.started) {
                return;
            }
            this.started = false;
            this.disposed = true;
            if (this.connectedTransport != null) {
                this.connectedTransport.stop();
                this.connectedTransport = null;
            }
            this.reconnectMutex.notifyAll();
        }
        object = this.sleepMutex;
        synchronized (object) {
            this.sleepMutex.notifyAll();
        }
        this.reconnectTask.shutdown();
    }

    public long getInitialReconnectDelay() {
        return this.initialReconnectDelay;
    }

    public void setInitialReconnectDelay(long initialReconnectDelay) {
        this.initialReconnectDelay = initialReconnectDelay;
    }

    public long getMaxReconnectDelay() {
        return this.maxReconnectDelay;
    }

    public void setMaxReconnectDelay(long maxReconnectDelay) {
        this.maxReconnectDelay = maxReconnectDelay;
    }

    public long getReconnectDelay() {
        return this.reconnectDelay;
    }

    public void setReconnectDelay(long reconnectDelay) {
        this.reconnectDelay = reconnectDelay;
    }

    public long getReconnectDelayExponent() {
        return this.backOffMultiplier;
    }

    public void setReconnectDelayExponent(long reconnectDelayExponent) {
        this.backOffMultiplier = reconnectDelayExponent;
    }

    public Transport getConnectedTransport() {
        return this.connectedTransport;
    }

    public URI getConnectedTransportURI() {
        return this.connectedTransportURI;
    }

    public int getMaxReconnectAttempts() {
        return this.maxReconnectAttempts;
    }

    public void setMaxReconnectAttempts(int maxReconnectAttempts) {
        this.maxReconnectAttempts = maxReconnectAttempts;
    }

    public boolean isRandomize() {
        return this.randomize;
    }

    public void setRandomize(boolean randomize) {
        this.randomize = randomize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void oneway(Command command) throws IOException {
        Exception error = null;
        try {
            Object object = this.reconnectMutex;
            synchronized (object) {
                int i = 0;
                while (!this.disposed) {
                    try {
                        while (this.connectedTransport == null && !this.disposed && this.connectionFailure == null) {
                            log.debug((Object)"Waiting for transport to reconnect.");
                            try {
                                this.reconnectMutex.wait(1000L);
                            }
                            catch (InterruptedException e) {
                                log.debug((Object)("Interupted: " + e), (Throwable)e);
                            }
                        }
                        if (this.connectedTransport == null) {
                            error = this.disposed ? new IOException("Transport disposed.") : (this.connectionFailure != null ? this.connectionFailure : new IOException("Unexpected failure."));
                            break;
                        }
                        if (!this.stateTracker.track(command) && command.isResponseRequired()) {
                            this.requestMap.put((Object)new Integer(command.getCommandId()), (Object)command);
                        }
                        try {
                            this.connectedTransport.oneway(command);
                        }
                        catch (IOException e) {
                            if (!this.stateTracker.track(command) && command.isResponseRequired()) {
                                this.requestMap.remove((Object)new Integer(command.getCommandId()), (Object)command);
                            }
                            throw e;
                        }
                        return;
                    }
                    catch (IOException e) {
                        log.debug((Object)("Send oneway attempt: " + i + " failed."));
                        this.handleTransportFailure(e);
                        ++i;
                    }
                }
            }
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
        if (!this.disposed && error != null) {
            if (error instanceof IOException) {
                throw (IOException)error;
            }
            throw IOExceptionSupport.create(error);
        }
    }

    public FutureResponse asyncRequest(Command command, ResponseCallback responseCallback) throws IOException {
        throw new AssertionError((Object)"Unsupported Method");
    }

    public Response request(Command command) throws IOException {
        throw new AssertionError((Object)"Unsupported Method");
    }

    public Response request(Command command, int timeout) throws IOException {
        throw new AssertionError((Object)"Unsupported Method");
    }

    public void add(URI[] u) {
        for (int i = 0; i < u.length; ++i) {
            if (this.uris.contains((Object)u[i])) continue;
            this.uris.add((Object)u[i]);
        }
        this.reconnect();
    }

    public void remove(URI[] u) {
        for (int i = 0; i < u.length; ++i) {
            this.uris.remove((Object)u[i]);
        }
        this.reconnect();
    }

    public void add(String u) {
        try {
            URI uri = new URI(u);
            if (!this.uris.contains((Object)uri)) {
                this.uris.add((Object)uri);
            }
            this.reconnect();
        }
        catch (Exception e) {
            log.error((Object)("Failed to parse URI: " + u));
        }
    }

    public void reconnect() {
        log.debug((Object)"Waking up reconnect task");
        try {
            this.reconnectTask.wakeup();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private ArrayList getConnectList() {
        ArrayList l = new ArrayList(this.uris);
        if (this.randomize) {
            Random r = new Random();
            r.setSeed(System.currentTimeMillis());
            for (int i = 0; i < l.size(); ++i) {
                int p = r.nextInt(l.size());
                Object t = l.get(p);
                l.set(p, l.get(i));
                l.set(i, t);
            }
        }
        return l;
    }

    public TransportListener getTransportListener() {
        return this.transportListener;
    }

    public void setTransportListener(TransportListener commandListener) {
        this.transportListener = commandListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object narrow(Class target) {
        if (target.isAssignableFrom(this.getClass())) {
            return this;
        }
        Object object = this.reconnectMutex;
        synchronized (object) {
            if (this.connectedTransport != null) {
                return this.connectedTransport.narrow(target);
            }
        }
        return null;
    }

    protected void restoreTransport(Transport t) throws Exception, IOException {
        t.start();
        this.stateTracker.restore(t);
        Iterator iter2 = this.requestMap.values().iterator();
        while (iter2.hasNext()) {
            Command command = (Command)iter2.next();
            t.oneway(command);
        }
    }

    public boolean isUseExponentialBackOff() {
        return this.useExponentialBackOff;
    }

    public void setUseExponentialBackOff(boolean useExponentialBackOff) {
        this.useExponentialBackOff = useExponentialBackOff;
    }

    public String toString() {
        return this.connectedTransportURI == null ? "unconnected" : this.connectedTransportURI.toString();
    }
}

