/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.fanout;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicInteger;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.Response;
import org.apache.activemq.state.ConnectionStateTracker;
import org.apache.activemq.thread.DefaultThreadPools;
import org.apache.activemq.thread.Task;
import org.apache.activemq.thread.TaskRunner;
import org.apache.activemq.transport.CompositeTransport;
import org.apache.activemq.transport.DefaultTransportListener;
import org.apache.activemq.transport.FutureResponse;
import org.apache.activemq.transport.ResponseCallback;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportFactory;
import org.apache.activemq.transport.TransportListener;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.activemq.util.ServiceStopper;
import org.apache.activemq.util.ServiceSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FanoutTransport
implements CompositeTransport {
    private static final Log log = LogFactory.getLog((Class)FanoutTransport.class);
    private TransportListener transportListener;
    private boolean disposed;
    private final Object reconnectMutex = new Object();
    private final ConnectionStateTracker stateTracker = new ConnectionStateTracker();
    private final ConcurrentHashMap requestMap = new ConcurrentHashMap();
    private final TaskRunner reconnectTask;
    private boolean started;
    private ArrayList transports = new ArrayList();
    private int connectedCount = 0;
    private int minAckCount = 2;
    private long initialReconnectDelay = 10L;
    private long maxReconnectDelay = 30000L;
    private long backOffMultiplier = 2L;
    private boolean useExponentialBackOff = true;
    private int maxReconnectAttempts;
    private Exception connectionFailure;
    private FanoutTransportHandler primary;

    public FanoutTransport() throws InterruptedIOException {
        this.reconnectTask = DefaultThreadPools.getDefaultTaskRunnerFactory().createTaskRunner(new Task(){

            public boolean iterate() {
                return FanoutTransport.this.doConnect();
            }
        }, "ActiveMQ Fanout Worker: " + System.identityHashCode(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doConnect() {
        long closestReconnectDate = 0L;
        Object object = this.reconnectMutex;
        synchronized (object) {
            if (this.disposed || this.connectionFailure != null) {
                this.reconnectMutex.notifyAll();
            }
            if (this.transports.size() == this.connectedCount || this.disposed || this.connectionFailure != null) {
                return false;
            }
            if (!this.transports.isEmpty()) {
                Iterator iter = this.transports.iterator();
                int i = 0;
                while (iter.hasNext() && !this.disposed) {
                    block22: {
                        long now = System.currentTimeMillis();
                        FanoutTransportHandler fanoutHandler = (FanoutTransportHandler)iter.next();
                        if (fanoutHandler.transport == null) {
                            if (fanoutHandler.reconnectDate != 0L && fanoutHandler.reconnectDate > now) {
                                if (closestReconnectDate == 0L || fanoutHandler.reconnectDate < closestReconnectDate) {
                                    closestReconnectDate = fanoutHandler.reconnectDate;
                                }
                            } else {
                                URI uri = fanoutHandler.uri;
                                try {
                                    log.debug((Object)("Stopped: " + this));
                                    log.debug((Object)("Attempting connect to: " + uri));
                                    Transport t = TransportFactory.compositeConnect(uri);
                                    log.debug((Object)"Connection established");
                                    fanoutHandler.transport = t;
                                    fanoutHandler.reconnectDelay = 10L;
                                    fanoutHandler.connectFailures = 0;
                                    if (this.primary == null) {
                                        this.primary = fanoutHandler;
                                    }
                                    t.setTransportListener(fanoutHandler);
                                    ++this.connectedCount;
                                    if (this.started) {
                                        this.restoreTransport(fanoutHandler);
                                    }
                                }
                                catch (Exception e) {
                                    log.debug((Object)("Connect fail to: " + uri + ", reason: " + e));
                                    if (this.maxReconnectAttempts > 0 && ++fanoutHandler.connectFailures >= this.maxReconnectAttempts) {
                                        log.error((Object)("Failed to connect to transport after: " + fanoutHandler.connectFailures + " attempt(s)"));
                                        this.connectionFailure = e;
                                        this.reconnectMutex.notifyAll();
                                        return false;
                                    }
                                    if (this.useExponentialBackOff) {
                                        fanoutHandler.reconnectDelay *= this.backOffMultiplier;
                                        if (fanoutHandler.reconnectDelay > this.maxReconnectDelay) {
                                            fanoutHandler.reconnectDelay = this.maxReconnectDelay;
                                        }
                                    }
                                    fanoutHandler.reconnectDate = now + fanoutHandler.reconnectDelay;
                                    if (closestReconnectDate != 0L && fanoutHandler.reconnectDate >= closestReconnectDate) break block22;
                                    closestReconnectDate = fanoutHandler.reconnectDate;
                                }
                            }
                        }
                    }
                    ++i;
                }
                if (this.transports.size() == this.connectedCount || this.disposed) {
                    this.reconnectMutex.notifyAll();
                    return false;
                }
            }
        }
        try {
            long reconnectDelay = closestReconnectDate - System.currentTimeMillis();
            if (reconnectDelay > 0L) {
                log.debug((Object)("Waiting " + reconnectDelay + " ms before attempting connection. "));
                Thread.sleep(reconnectDelay);
            }
        }
        catch (InterruptedException e1) {
            Thread.currentThread().interrupt();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        Object object = this.reconnectMutex;
        synchronized (object) {
            log.debug((Object)"Started.");
            if (this.started) {
                return;
            }
            this.started = true;
            Iterator iter = this.transports.iterator();
            while (iter.hasNext()) {
                FanoutTransportHandler th = (FanoutTransportHandler)iter.next();
                if (th.transport == null) continue;
                this.restoreTransport(th);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws Exception {
        Object object = this.reconnectMutex;
        synchronized (object) {
            ServiceStopper ss = new ServiceStopper();
            if (!this.started) {
                return;
            }
            this.started = false;
            this.disposed = true;
            Iterator iter = this.transports.iterator();
            while (iter.hasNext()) {
                FanoutTransportHandler th = (FanoutTransportHandler)iter.next();
                if (th.transport == null) continue;
                ss.stop(th.transport);
            }
            log.debug((Object)("Stopped: " + this));
            ss.throwFirstException();
        }
        this.reconnectTask.shutdown();
    }

    public long getInitialReconnectDelay() {
        return this.initialReconnectDelay;
    }

    public void setInitialReconnectDelay(long initialReconnectDelay) {
        this.initialReconnectDelay = initialReconnectDelay;
    }

    public long getMaxReconnectDelay() {
        return this.maxReconnectDelay;
    }

    public void setMaxReconnectDelay(long maxReconnectDelay) {
        this.maxReconnectDelay = maxReconnectDelay;
    }

    public long getReconnectDelayExponent() {
        return this.backOffMultiplier;
    }

    public void setReconnectDelayExponent(long reconnectDelayExponent) {
        this.backOffMultiplier = reconnectDelayExponent;
    }

    public int getMaxReconnectAttempts() {
        return this.maxReconnectAttempts;
    }

    public void setMaxReconnectAttempts(int maxReconnectAttempts) {
        this.maxReconnectAttempts = maxReconnectAttempts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void oneway(Command command) throws IOException {
        try {
            Object object = this.reconnectMutex;
            synchronized (object) {
                boolean fanout = this.isFanoutCommand(command);
                if (!this.stateTracker.track(command) && command.isResponseRequired()) {
                    int size = fanout ? this.minAckCount : 1;
                    this.requestMap.put((Object)new Integer(command.getCommandId()), (Object)new RequestCounter(command, size));
                }
                while (this.connectedCount != this.minAckCount && !this.disposed && this.connectionFailure == null) {
                    log.debug((Object)("Waiting for at least " + this.minAckCount + " transports to be connected."));
                    this.reconnectMutex.wait(1000L);
                }
                if (this.connectedCount != this.minAckCount) {
                    Exception error = this.disposed ? new IOException("Transport disposed.") : (this.connectionFailure != null ? this.connectionFailure : new IOException("Unexpected failure."));
                    if (error instanceof IOException) {
                        throw error;
                    }
                    throw IOExceptionSupport.create(error);
                }
                if (fanout) {
                    Iterator iter = this.transports.iterator();
                    while (iter.hasNext()) {
                        FanoutTransportHandler th = (FanoutTransportHandler)iter.next();
                        if (th.transport == null) continue;
                        try {
                            th.transport.oneway(command);
                        }
                        catch (IOException e) {
                            log.debug((Object)"Send attempt: failed.");
                            th.onException(e);
                        }
                    }
                } else {
                    try {
                        this.primary.transport.oneway(command);
                    }
                    catch (IOException e) {
                        log.debug((Object)"Send attempt: failed.");
                        this.primary.onException(e);
                    }
                }
            }
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
    }

    private boolean isFanoutCommand(Command command) {
        if (command.isMessage()) {
            return ((Message)command).getDestination().isTopic();
        }
        return command.getDataStructureType() != 5;
    }

    public FutureResponse asyncRequest(Command command, ResponseCallback responseCallback) throws IOException {
        throw new AssertionError((Object)"Unsupported Method");
    }

    public Response request(Command command) throws IOException {
        throw new AssertionError((Object)"Unsupported Method");
    }

    public Response request(Command command, int timeout) throws IOException {
        throw new AssertionError((Object)"Unsupported Method");
    }

    public void reconnect() {
        log.debug((Object)"Waking up reconnect task");
        try {
            this.reconnectTask.wakeup();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public TransportListener getTransportListener() {
        return this.transportListener;
    }

    public void setTransportListener(TransportListener commandListener) {
        this.transportListener = commandListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object narrow(Class target) {
        if (target.isAssignableFrom(this.getClass())) {
            return this;
        }
        Object object = this.reconnectMutex;
        synchronized (object) {
            Iterator iter = this.transports.iterator();
            while (iter.hasNext()) {
                Object rc;
                FanoutTransportHandler th = (FanoutTransportHandler)iter.next();
                if (th.transport == null || (rc = th.transport.narrow(target)) == null) continue;
                return rc;
            }
        }
        return null;
    }

    protected void restoreTransport(FanoutTransportHandler th) throws Exception, IOException {
        th.transport.start();
        this.stateTracker.setRestoreConsumers(th.transport == this.primary);
        this.stateTracker.restore(th.transport);
        Iterator iter2 = this.requestMap.values().iterator();
        while (iter2.hasNext()) {
            RequestCounter rc = (RequestCounter)iter2.next();
            th.transport.oneway(rc.command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(URI[] uris) {
        Object object = this.reconnectMutex;
        synchronized (object) {
            for (int i = 0; i < uris.length; ++i) {
                URI uri = uris[i];
                boolean match = false;
                Iterator iter = this.transports.iterator();
                while (iter.hasNext()) {
                    FanoutTransportHandler th = (FanoutTransportHandler)iter.next();
                    if (!th.uri.equals(uri)) continue;
                    match = true;
                    break;
                }
                if (match) continue;
                FanoutTransportHandler th = new FanoutTransportHandler(uri);
                this.transports.add(th);
                this.reconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(URI[] uris) {
        Object object = this.reconnectMutex;
        synchronized (object) {
            block3: for (int i = 0; i < uris.length; ++i) {
                URI uri = uris[i];
                boolean match = false;
                Iterator iter = this.transports.iterator();
                while (iter.hasNext()) {
                    FanoutTransportHandler th = (FanoutTransportHandler)iter.next();
                    if (!th.uri.equals(uri)) continue;
                    if (th.transport != null) {
                        ServiceSupport.dispose(th.transport);
                        --this.connectedCount;
                    }
                    iter.remove();
                    continue block3;
                }
            }
        }
    }

    class FanoutTransportHandler
    extends DefaultTransportListener {
        private final URI uri;
        private Transport transport;
        private int connectFailures;
        private long reconnectDelay;
        private long reconnectDate;

        public FanoutTransportHandler(URI uri) {
            this.reconnectDelay = FanoutTransport.this.initialReconnectDelay;
            this.uri = uri;
        }

        public void onCommand(Command command) {
            if (command.isResponse()) {
                Integer id = new Integer(((Response)command).getCorrelationId());
                RequestCounter rc = (RequestCounter)FanoutTransport.this.requestMap.get((Object)id);
                if (rc != null) {
                    if (rc.ackCount.decrementAndGet() <= 0) {
                        FanoutTransport.this.requestMap.remove((Object)id);
                        FanoutTransport.this.transportListener.onCommand(command);
                    }
                } else {
                    FanoutTransport.this.transportListener.onCommand(command);
                }
            } else {
                FanoutTransport.this.transportListener.onCommand(command);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onException(IOException error) {
            try {
                Object object = FanoutTransport.this.reconnectMutex;
                synchronized (object) {
                    if (this.transport == null) {
                        return;
                    }
                    log.debug((Object)"Transport failed, starting up reconnect task", (Throwable)error);
                    ServiceSupport.dispose(this.transport);
                    this.transport = null;
                    FanoutTransport.this.connectedCount--;
                    if (FanoutTransport.this.primary == this) {
                        FanoutTransport.this.primary = null;
                    }
                    FanoutTransport.this.reconnectTask.wakeup();
                }
            }
            catch (InterruptedException e) {
                FanoutTransport.this.transportListener.onException(new InterruptedIOException());
            }
        }
    }

    static class RequestCounter {
        final Command command;
        final AtomicInteger ackCount;

        RequestCounter(Command command, int count) {
            this.command = command;
            this.ackCount = new AtomicInteger(count);
        }

        public String toString() {
            return this.command.getCommandId() + "=" + this.ackCount.get();
        }
    }
}

