/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.mock;

import java.io.IOException;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.Response;
import org.apache.activemq.transport.DefaultTransportListener;
import org.apache.activemq.transport.FutureResponse;
import org.apache.activemq.transport.ResponseCallback;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportFilter;
import org.apache.activemq.transport.TransportListener;

public class MockTransport
extends DefaultTransportListener
implements Transport {
    protected Transport next;
    protected TransportListener transportListener;

    public MockTransport(Transport next) {
        this.next = next;
    }

    public synchronized void setTransportListener(TransportListener channelListener) {
        this.transportListener = channelListener;
        if (channelListener == null) {
            this.next.setTransportListener(null);
        } else {
            this.next.setTransportListener(this);
        }
    }

    public void start() throws Exception {
        if (this.next == null) {
            throw new IOException("The next channel has not been set.");
        }
        if (this.transportListener == null) {
            throw new IOException("The command listener has not been set.");
        }
        this.next.start();
    }

    public void stop() throws Exception {
        this.next.stop();
    }

    public synchronized void onCommand(Command command) {
        this.transportListener.onCommand(command);
    }

    public synchronized Transport getNext() {
        return this.next;
    }

    public synchronized TransportListener getTransportListener() {
        return this.transportListener;
    }

    public synchronized String toString() {
        return this.next.toString();
    }

    public synchronized void oneway(Command command) throws IOException {
        this.next.oneway(command);
    }

    public synchronized FutureResponse asyncRequest(Command command, ResponseCallback responseCallback) throws IOException {
        return this.next.asyncRequest(command, null);
    }

    public synchronized Response request(Command command) throws IOException {
        return this.next.request(command);
    }

    public Response request(Command command, int timeout) throws IOException {
        return this.next.request(command, timeout);
    }

    public synchronized void onException(IOException error) {
        this.transportListener.onException(error);
    }

    public synchronized Object narrow(Class target) {
        if (target.isAssignableFrom(this.getClass())) {
            return this;
        }
        return this.next.narrow(target);
    }

    public synchronized void setNext(Transport next) {
        this.next = next;
    }

    public synchronized void install(TransportFilter filter) {
        filter.setTransportListener(this);
        this.getNext().setTransportListener(filter);
        this.setNext(filter);
    }
}

