/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.stomp;

import java.io.DataInput;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.Properties;
import org.apache.activemq.command.TransactionId;
import org.apache.activemq.command.TransactionInfo;
import org.apache.activemq.transport.stomp.CommandEnvelope;
import org.apache.activemq.transport.stomp.HeaderParser;
import org.apache.activemq.transport.stomp.StompCommand;
import org.apache.activemq.transport.stomp.StompWireFormat;

class Abort
implements StompCommand {
    private StompWireFormat format;
    private static final HeaderParser parser = new HeaderParser();

    Abort(StompWireFormat format) {
        this.format = format;
    }

    public CommandEnvelope build(String commandLine, DataInput in) throws IOException {
        Properties headers = parser.parse(in);
        while (in.readByte() != 0) {
        }
        String user_tx_id = headers.getProperty("transaction");
        if (!headers.containsKey("transaction")) {
            throw new ProtocolException("Must specify the transaction you are aborting");
        }
        TransactionId txnId = this.format.getTransactionId(user_tx_id);
        TransactionInfo tx = new TransactionInfo();
        tx.setConnectionId(this.format.getConnectionId());
        tx.setTransactionId(txnId);
        tx.setType((byte)4);
        this.format.clearTransactionId(user_tx_id);
        return new CommandEnvelope(tx, headers);
    }
}

