/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.stomp;

import java.io.DataInput;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.Properties;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.TransactionId;
import org.apache.activemq.transport.stomp.CommandEnvelope;
import org.apache.activemq.transport.stomp.HeaderParser;
import org.apache.activemq.transport.stomp.StompCommand;
import org.apache.activemq.transport.stomp.StompWireFormat;
import org.apache.activemq.transport.stomp.Subscription;

class Ack
implements StompCommand {
    private final StompWireFormat format;
    private static final HeaderParser parser = new HeaderParser();

    Ack(StompWireFormat format) {
        this.format = format;
    }

    public CommandEnvelope build(String commandLine, DataInput in) throws IOException {
        Properties headers = parser.parse(in);
        String message_id = headers.getProperty("message-id");
        if (message_id == null) {
            throw new ProtocolException("ACK received without a message-id to acknowledge!");
        }
        Subscription sub = (Subscription)this.format.getDispachedMap().get(message_id);
        if (sub == null) {
            throw new ProtocolException("Unexpected ACK received for message-id [" + message_id + "]");
        }
        MessageAck ack = sub.createMessageAck(message_id);
        if (headers.containsKey("transaction")) {
            TransactionId tx_id = this.format.getTransactionId(headers.getProperty("transaction"));
            if (tx_id == null) {
                throw new ProtocolException(headers.getProperty("transaction") + " is an invalid transaction id");
            }
            ack.setTransactionId(tx_id);
        }
        while (in.readByte() != 0) {
        }
        return new CommandEnvelope(ack, headers);
    }
}

