/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.stomp;

import java.io.DataInput;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.Properties;
import org.apache.activemq.command.TransactionId;
import org.apache.activemq.command.TransactionInfo;
import org.apache.activemq.transport.stomp.CommandEnvelope;
import org.apache.activemq.transport.stomp.HeaderParser;
import org.apache.activemq.transport.stomp.StompCommand;
import org.apache.activemq.transport.stomp.StompWireFormat;

public class Begin
implements StompCommand {
    private StompWireFormat format;
    private static final HeaderParser parser = new HeaderParser();

    public Begin(StompWireFormat format) {
        this.format = format;
    }

    public CommandEnvelope build(String commandLine, DataInput in) throws IOException {
        Properties headers = parser.parse(in);
        while (in.readByte() != 0) {
        }
        TransactionInfo tx = new TransactionInfo();
        String user_tx_id = headers.getProperty("transaction");
        if (!headers.containsKey("transaction")) {
            throw new ProtocolException("Must specify the transaction you are beginning");
        }
        int tx_id = StompWireFormat.generateTransactionId();
        TransactionId transactionId = this.format.registerTransactionId(user_tx_id, tx_id);
        tx.setConnectionId(this.format.getConnectionId());
        tx.setTransactionId(transactionId);
        tx.setType((byte)0);
        return new CommandEnvelope(tx, headers);
    }
}

