/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.stomp;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.ProtocolException;
import javax.jms.JMSException;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.Response;
import org.apache.activemq.transport.stomp.Abort;
import org.apache.activemq.transport.stomp.Ack;
import org.apache.activemq.transport.stomp.Begin;
import org.apache.activemq.transport.stomp.CommandEnvelope;
import org.apache.activemq.transport.stomp.Commit;
import org.apache.activemq.transport.stomp.Connect;
import org.apache.activemq.transport.stomp.Disconnect;
import org.apache.activemq.transport.stomp.FrameBuilder;
import org.apache.activemq.transport.stomp.ResponseListener;
import org.apache.activemq.transport.stomp.Send;
import org.apache.activemq.transport.stomp.StompCommand;
import org.apache.activemq.transport.stomp.StompWireFormat;
import org.apache.activemq.transport.stomp.Subscribe;
import org.apache.activemq.transport.stomp.Unsubscribe;

class CommandParser {
    private final StompWireFormat format;

    CommandParser(StompWireFormat wireFormat) {
        this.format = wireFormat;
    }

    Command parse(DataInput in) throws IOException, JMSException {
        String line = null;
        do {
            if ((line = in.readLine()) != null) continue;
            throw new IOException("connection was closed");
        } while ((line = line.trim()).length() <= 0);
        StompCommand command = null;
        if (line.startsWith("CONNECT")) {
            command = new Connect(this.format);
        } else if (line.startsWith("SUB")) {
            command = new Subscribe(this.format);
        } else if (line.startsWith("SEND")) {
            command = new Send(this.format);
        } else if (line.startsWith("DISCONNECT")) {
            command = new Disconnect();
        } else if (line.startsWith("BEGIN")) {
            command = new Begin(this.format);
        } else if (line.startsWith("COMMIT")) {
            command = new Commit(this.format);
        } else if (line.startsWith("ABORT")) {
            command = new Abort(this.format);
        } else if (line.startsWith("UNSUB")) {
            command = new Unsubscribe(this.format);
        } else if (line.startsWith("ACK")) {
            command = new Ack(this.format);
        }
        if (command == null) {
            while (in.readByte() == 0) {
            }
            throw new ProtocolException("Unknown command [" + line + "]");
        }
        CommandEnvelope envelope = command.build(line, in);
        final short commandId = this.format.generateCommandId();
        final String client_packet_key = envelope.getHeaders().getProperty("receipt");
        boolean receiptRequested = client_packet_key != null;
        envelope.getCommand().setCommandId(commandId);
        if (receiptRequested || envelope.getResponseListener() != null) {
            envelope.getCommand().setResponseRequired(true);
            if (envelope.getResponseListener() != null) {
                this.format.addResponseListener(envelope.getResponseListener());
            } else {
                this.format.addResponseListener(new ResponseListener(){

                    public boolean onResponse(Response receipt, DataOutput out) throws IOException {
                        if (receipt.getCorrelationId() != commandId) {
                            return false;
                        }
                        out.write(new FrameBuilder("RECEIPT").addHeader("receipt-id", client_packet_key).toFrame());
                        return true;
                    }
                });
            }
        }
        return envelope.getCommand();
    }
}

