/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.stomp;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Properties;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.command.ProducerInfo;
import org.apache.activemq.command.Response;
import org.apache.activemq.command.SessionInfo;
import org.apache.activemq.transport.stomp.CommandEnvelope;
import org.apache.activemq.transport.stomp.HeaderParser;
import org.apache.activemq.transport.stomp.ResponseListener;
import org.apache.activemq.transport.stomp.StompCommand;
import org.apache.activemq.transport.stomp.StompWireFormat;
import org.apache.activemq.util.IntrospectionSupport;

class Connect
implements StompCommand {
    private HeaderParser headerParser = new HeaderParser();
    private StompWireFormat format;

    Connect(StompWireFormat format) {
        this.format = format;
    }

    public CommandEnvelope build(String commandLine, DataInput in) throws IOException {
        Properties headers = this.headerParser.parse(in);
        String login = headers.getProperty("login");
        String passcode = headers.getProperty("passcode");
        String clientId = headers.getProperty("client-id");
        final ConnectionInfo connectionInfo = new ConnectionInfo();
        IntrospectionSupport.setProperties(connectionInfo, headers, "activemq.");
        connectionInfo.setConnectionId(this.format.getConnectionId());
        if (clientId != null) {
            connectionInfo.setClientId(clientId);
        } else {
            connectionInfo.setClientId("" + connectionInfo.getConnectionId().toString());
        }
        connectionInfo.setResponseRequired(true);
        connectionInfo.setUserName(login);
        connectionInfo.setPassword(passcode);
        while (in.readByte() != 0) {
        }
        return new CommandEnvelope(connectionInfo, headers, new ResponseListener(){

            public boolean onResponse(Response receipt, DataOutput out) throws IOException {
                if (receipt.getCorrelationId() != connectionInfo.getCommandId()) {
                    return false;
                }
                SessionInfo sessionInfo = new SessionInfo(Connect.this.format.getSessionId());
                sessionInfo.setCommandId(Connect.this.format.generateCommandId());
                sessionInfo.setResponseRequired(false);
                final ProducerInfo producerInfo = new ProducerInfo(Connect.this.format.getProducerId());
                producerInfo.setCommandId(Connect.this.format.generateCommandId());
                producerInfo.setResponseRequired(true);
                Connect.this.format.addResponseListener(new ResponseListener(){

                    public boolean onResponse(Response receipt, DataOutput out) throws IOException {
                        if (receipt.getCorrelationId() != producerInfo.getCommandId()) {
                            return false;
                        }
                        Connect.this.format.onFullyConnected();
                        StringBuffer buffer = new StringBuffer();
                        buffer.append("CONNECTED");
                        buffer.append("\n");
                        buffer.append("session");
                        buffer.append(":");
                        buffer.append(connectionInfo.getClientId());
                        buffer.append("\n");
                        buffer.append("\n");
                        buffer.append("\u0000");
                        buffer.append("\n");
                        out.writeBytes(buffer.toString());
                        return true;
                    }
                });
                Connect.this.format.addToPendingReadCommands(sessionInfo);
                Connect.this.format.addToPendingReadCommands(producerInfo);
                return true;
            }
        });
    }
}

