/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.stomp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.transport.stomp.DestinationNamer;

class FrameBuilder {
    private String command;
    private Properties headers = new Properties();
    private byte[] body = new byte[0];

    public FrameBuilder(String command) {
        this.command = command;
    }

    public FrameBuilder addHeader(String key, String value) {
        if (value != null) {
            this.headers.setProperty(key, value);
        }
        return this;
    }

    public FrameBuilder addHeader(String key, long value) {
        this.headers.put(key, new Long(value));
        return this;
    }

    public FrameBuilder addHeaders(ActiveMQMessage message) throws IOException {
        this.addHeader("destination", DestinationNamer.convert(message.getDestination()));
        this.addHeader("message-id", message.getJMSMessageID());
        this.addHeader("correlation-id", message.getJMSCorrelationID());
        this.addHeader("expires", message.getJMSExpiration());
        if (message.getJMSRedelivered()) {
            this.addHeader("redelivered", "true");
        }
        this.addHeader("priority", message.getJMSPriority());
        this.addHeader("reply-to", DestinationNamer.convert(message.getJMSReplyTo()));
        this.addHeader("timestamp", message.getJMSTimestamp());
        this.addHeader("type", message.getJMSType());
        Map properties = message.getProperties();
        if (properties != null) {
            this.headers.putAll((Map<?, ?>)properties);
        }
        return this;
    }

    public FrameBuilder setBody(byte[] body) {
        this.body = body;
        return this;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.command);
        buffer.append("\n");
        Iterator<Object> iterator = this.headers.keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            String property = this.headers.getProperty(key);
            if (property == null) continue;
            buffer.append(key);
            buffer.append(":");
            buffer.append(property);
            buffer.append("\n");
        }
        buffer.append("\n");
        buffer.append(this.body);
        buffer.append("\u0000");
        buffer.append("\n");
        return buffer.toString();
    }

    byte[] toFrame() {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            bout.write(this.command.getBytes("UTF-8"));
            bout.write("\n".getBytes("UTF-8"));
            Iterator<Map.Entry<Object, Object>> iterator = this.headers.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Object, Object> entry = iterator.next();
                String key = (String)entry.getKey();
                String property = entry.getValue().toString();
                if (property == null) continue;
                bout.write(key.getBytes("UTF-8"));
                bout.write(":".getBytes("UTF-8"));
                bout.write(property.getBytes("UTF-8"));
                bout.write("\n".getBytes("UTF-8"));
            }
            bout.write("\n".getBytes("UTF-8"));
            bout.write(this.body);
            bout.write("\u0000".getBytes("UTF-8"));
            bout.write("\n".getBytes("UTF-8"));
        }
        catch (IOException e) {
            throw new RuntimeException("World is caving in, we just got io error writing toa byte array output stream we instantiated!");
        }
        return bout.toByteArray();
    }
}

