/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.stomp;

import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.Properties;
import javax.jms.JMSException;
import org.apache.activemq.command.ActiveMQBytesMessage;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.apache.activemq.command.TransactionId;
import org.apache.activemq.transport.stomp.CommandEnvelope;
import org.apache.activemq.transport.stomp.DestinationNamer;
import org.apache.activemq.transport.stomp.HeaderParser;
import org.apache.activemq.transport.stomp.Stomp;
import org.apache.activemq.transport.stomp.StompCommand;
import org.apache.activemq.transport.stomp.StompWireFormat;

class Send
implements StompCommand {
    private final HeaderParser parser = new HeaderParser();
    private final StompWireFormat format;

    Send(StompWireFormat format) {
        this.format = format;
    }

    public CommandEnvelope build(String commandLine, DataInput in) throws IOException, JMSException {
        Object type;
        Object priority;
        ActiveMQMessage msg;
        Properties headers = this.parser.parse(in);
        String destination = (String)headers.remove("destination");
        if (headers.containsKey("content-length")) {
            int length;
            ActiveMQBytesMessage bm = new ActiveMQBytesMessage();
            String content_length = headers.getProperty("content-length").trim();
            try {
                length = Integer.parseInt(content_length);
            }
            catch (NumberFormatException e) {
                throw new ProtocolException("Specified content-length is not a valid integer");
            }
            byte[] bytes = new byte[length];
            in.readFully(bytes);
            byte nil = in.readByte();
            if (nil != 0) {
                throw new ProtocolException("content-length bytes were read and there was no trailing null byte");
            }
            bm.writeBytes(bytes);
            msg = bm;
        } else {
            byte b;
            ActiveMQTextMessage text = new ActiveMQTextMessage();
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            while ((b = in.readByte()) != 0) {
                bytes.write(b);
            }
            bytes.close();
            String body = new String(bytes.toByteArray());
            try {
                text.setText(body);
            }
            catch (JMSException e) {
                throw new RuntimeException("Something is really wrong, we instantiated this thing!");
            }
            msg = text;
        }
        msg.setProducerId(this.format.getProducerId());
        msg.setMessageId(this.format.createMessageId());
        ActiveMQDestination d = DestinationNamer.convert(destination);
        msg.setDestination(d);
        msg.setJMSCorrelationID((String)headers.remove("correlation-id"));
        Object expiration = headers.remove("expires");
        if (expiration != null) {
            msg.setJMSExpiration(this.asLong(expiration));
        }
        if ((priority = headers.remove("priority")) != null) {
            msg.setJMSPriority(this.asInt(priority));
        }
        if ((type = headers.remove("type")) != null) {
            msg.setJMSType((String)type);
        }
        msg.setJMSReplyTo(DestinationNamer.convert((String)headers.remove("reply-to")));
        Object persistent = headers.remove(Stomp.Headers.Send.PERSISTENT);
        if (persistent != null) {
            msg.setPersistent(this.asBool(persistent));
        }
        headers.remove("content-length");
        msg.setProperties(headers);
        if (headers.containsKey("transaction")) {
            TransactionId tx_id = this.format.getTransactionId(headers.getProperty("transaction"));
            if (tx_id == null) {
                throw new ProtocolException(headers.getProperty("transaction") + " is an invalid transaction id");
            }
            msg.setTransactionId(tx_id);
        }
        msg.onSend();
        return new CommandEnvelope(msg, headers);
    }

    protected boolean asBool(Object value) {
        if (value != null) {
            return String.valueOf(value).equals("true");
        }
        return false;
    }

    protected long asLong(Object value) {
        if (value instanceof Number) {
            Number n = (Number)value;
            return n.longValue();
        }
        return Long.parseLong(value.toString());
    }

    protected int asInt(Object value) {
        if (value instanceof Number) {
            Number n = (Number)value;
            return n.intValue();
        }
        return Integer.parseInt(value.toString());
    }
}

