/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.stomp;

import java.io.DataInput;
import java.io.IOException;
import java.util.Properties;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.transport.stomp.CommandEnvelope;
import org.apache.activemq.transport.stomp.DestinationNamer;
import org.apache.activemq.transport.stomp.HeaderParser;
import org.apache.activemq.transport.stomp.StompCommand;
import org.apache.activemq.transport.stomp.StompWireFormat;
import org.apache.activemq.transport.stomp.Subscription;
import org.apache.activemq.util.IntrospectionSupport;

class Subscribe
implements StompCommand {
    private HeaderParser headerParser = new HeaderParser();
    private StompWireFormat format;

    Subscribe(StompWireFormat format) {
        this.format = format;
    }

    public CommandEnvelope build(String commandLine, DataInput in) throws IOException {
        Properties headers = this.headerParser.parse(in);
        String subscriptionId = headers.getProperty("id");
        String destination = headers.getProperty("destination");
        ActiveMQDestination actual_dest = DestinationNamer.convert(destination);
        ConsumerInfo ci = new ConsumerInfo(this.format.createConsumerId());
        ci.setPrefetchSize(1000);
        ci.setDispatchAsync(true);
        String selector = (String)headers.remove("selector");
        ci.setSelector(selector);
        IntrospectionSupport.setProperties(ci, headers, "activemq.");
        ci.setDestination(DestinationNamer.convert(destination));
        while (in.readByte() != 0) {
        }
        Subscription s = new Subscription(this.format, subscriptionId, ci);
        s.setDestination(actual_dest);
        String ack_mode_key = headers.getProperty("ack");
        if (ack_mode_key != null && ack_mode_key.equals("client")) {
            s.setAckMode(2);
        }
        this.format.addSubscription(s);
        return new CommandEnvelope(ci, headers);
    }
}

