/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.tcp;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import javax.net.ServerSocketFactory;
import org.apache.activeio.command.WireFormat;
import org.apache.activeio.command.WireFormatFactory;
import org.apache.activemq.command.BrokerInfo;
import org.apache.activemq.openwire.OpenWireFormatFactory;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportServerThreadSupport;
import org.apache.activemq.transport.tcp.TcpTransport;
import org.apache.activemq.transport.tcp.TcpTransportFactory;
import org.apache.activemq.util.ServiceStopper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TcpTransportServer
extends TransportServerThreadSupport {
    private static final Log log = LogFactory.getLog((Class)TcpTransportServer.class);
    private ServerSocket serverSocket;
    private int backlog = 5000;
    private WireFormatFactory wireFormatFactory = new OpenWireFormatFactory();
    private TcpTransportFactory transportFactory = new TcpTransportFactory();
    private long maxInactivityDuration = 30000L;
    private int minmumWireFormatVersion;
    private boolean trace;
    private Map transportOptions;

    public TcpTransportServer(URI location, ServerSocketFactory serverSocketFactory) throws IOException, URISyntaxException {
        super(location);
        this.serverSocket = this.createServerSocket(location, serverSocketFactory);
        this.serverSocket.setSoTimeout(2000);
        this.updatePhysicalUri(location);
    }

    public WireFormatFactory getWireFormatFactory() {
        return this.wireFormatFactory;
    }

    public void setWireFormatFactory(WireFormatFactory wireFormatFactory) {
        this.wireFormatFactory = wireFormatFactory;
    }

    public void setBrokerInfo(BrokerInfo brokerInfo) {
    }

    public long getMaxInactivityDuration() {
        return this.maxInactivityDuration;
    }

    public void setMaxInactivityDuration(long maxInactivityDuration) {
        this.maxInactivityDuration = maxInactivityDuration;
    }

    public int getMinmumWireFormatVersion() {
        return this.minmumWireFormatVersion;
    }

    public void setMinmumWireFormatVersion(int minmumWireFormatVersion) {
        this.minmumWireFormatVersion = minmumWireFormatVersion;
    }

    public boolean isTrace() {
        return this.trace;
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    public void run() {
        while (!this.isStopped()) {
            Socket socket = null;
            try {
                socket = this.serverSocket.accept();
                if (socket == null) continue;
                if (this.isStopped() || this.getAcceptListener() == null) {
                    socket.close();
                    continue;
                }
                HashMap<String, Serializable> options = new HashMap<String, Serializable>();
                options.put("maxInactivityDuration", new Long(this.maxInactivityDuration));
                options.put("minmumWireFormatVersion", new Integer(this.minmumWireFormatVersion));
                options.put("trace", new Boolean(this.trace));
                options.putAll(this.transportOptions);
                WireFormat format = this.wireFormatFactory.createWireFormat();
                TcpTransport transport = new TcpTransport(format, socket);
                Transport configuredTransport = this.transportFactory.configure(transport, format, options);
                this.getAcceptListener().onAccept(configuredTransport);
            }
            catch (SocketTimeoutException ste) {
            }
            catch (Exception e) {
                if (!this.isStopping()) {
                    this.onAcceptError(e);
                    continue;
                }
                if (this.isStopped()) continue;
                log.warn((Object)"run()", (Throwable)e);
                this.onAcceptError(e);
            }
        }
    }

    public String toString() {
        return "" + this.getLocation();
    }

    protected void updatePhysicalUri(URI bindAddr) throws URISyntaxException, UnknownHostException {
        this.setLocation(new URI(bindAddr.getScheme(), bindAddr.getUserInfo(), this.resolveHostName(bindAddr.getHost()), this.serverSocket.getLocalPort(), bindAddr.getPath(), bindAddr.getQuery(), bindAddr.getFragment()));
    }

    protected String resolveHostName(String hostName) throws UnknownHostException {
        String result = hostName;
        if (hostName != null && (hostName.equalsIgnoreCase("localhost") || hostName.equals("127.0.0.1"))) {
            result = InetAddress.getLocalHost().getHostName();
        }
        return result;
    }

    protected ServerSocket createServerSocket(URI bind, ServerSocketFactory factory) throws UnknownHostException, IOException {
        ServerSocket answer = null;
        String host = bind.getHost();
        host = host == null || host.length() == 0 ? "localhost" : host;
        InetAddress addr = InetAddress.getByName(host);
        answer = host.trim().equals("localhost") || addr.equals(InetAddress.getLocalHost()) ? factory.createServerSocket(bind.getPort(), this.backlog) : factory.createServerSocket(bind.getPort(), this.backlog, addr);
        return answer;
    }

    protected void doStop(ServiceStopper stopper) throws Exception {
        super.doStop(stopper);
        if (this.serverSocket != null) {
            this.serverSocket.close();
        }
    }

    public InetSocketAddress getSocketAddress() {
        return (InetSocketAddress)this.serverSocket.getLocalSocketAddress();
    }

    public void setTransportOption(Map transportOptions) {
        this.transportOptions = transportOptions;
    }
}

