/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.udp;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketAddress;
import org.apache.activeio.util.ByteArrayInputStream;
import org.apache.activeio.util.ByteArrayOutputStream;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.Endpoint;
import org.apache.activemq.openwire.BooleanStream;
import org.apache.activemq.openwire.OpenWireFormat;
import org.apache.activemq.transport.reliable.ReplayBuffer;
import org.apache.activemq.transport.udp.CommandChannelSupport;
import org.apache.activemq.transport.udp.DatagramHeaderMarshaller;
import org.apache.activemq.transport.udp.UdpTransport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CommandDatagramSocket
extends CommandChannelSupport {
    private static final Log log = LogFactory.getLog((Class)CommandDatagramSocket.class);
    private DatagramSocket channel;
    private Object readLock = new Object();
    private Object writeLock = new Object();

    public CommandDatagramSocket(UdpTransport transport, OpenWireFormat wireFormat, int datagramSize, SocketAddress targetAddress, DatagramHeaderMarshaller headerMarshaller, DatagramSocket channel) {
        super(transport, wireFormat, datagramSize, targetAddress, headerMarshaller);
        this.channel = channel;
    }

    public void start() throws Exception {
    }

    public void stop() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Command read() throws IOException {
        Command answer = null;
        Endpoint from = null;
        Object object = this.readLock;
        synchronized (object) {
            DatagramPacket datagram = this.createDatagramPacket();
            this.channel.receive(datagram);
            DataInputStream dataIn = new DataInputStream((InputStream)new ByteArrayInputStream(datagram.getData()));
            from = this.headerMarshaller.createEndpoint(datagram, dataIn);
            answer = (Command)this.wireFormat.unmarshal(dataIn);
        }
        if (answer != null) {
            answer.setFrom(from);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Channel: " + this.name + " about to process: " + answer));
            }
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Command command, SocketAddress address) throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            ByteArrayOutputStream writeBuffer = this.createByteArrayOutputStream();
            DataOutputStream dataOut = new DataOutputStream((OutputStream)writeBuffer);
            this.headerMarshaller.writeHeader(command, dataOut);
            int offset = writeBuffer.size();
            this.wireFormat.marshal(command, dataOut);
            if (this.remaining(writeBuffer) >= 0) {
                this.sendWriteBuffer(address, writeBuffer, command.getCommandId());
            } else {
                byte[] data = writeBuffer.toByteArray();
                boolean lastFragment = false;
                int fragment = 0;
                int length = data.length;
                while (!lastFragment) {
                    writeBuffer = this.createByteArrayOutputStream();
                    this.headerMarshaller.writeHeader(command, dataOut);
                    int chunkSize = this.remaining(writeBuffer);
                    BooleanStream bs = null;
                    if (this.wireFormat.isTightEncodingEnabled()) {
                        bs = new BooleanStream();
                        bs.writeBoolean(true);
                    }
                    chunkSize -= 9;
                    chunkSize = bs != null ? (chunkSize -= bs.marshalledSize()) : --chunkSize;
                    if (!this.wireFormat.isSizePrefixDisabled()) {
                        dataOut.writeInt(chunkSize);
                        chunkSize -= 4;
                    }
                    boolean bl = lastFragment = offset + chunkSize >= length;
                    if (chunkSize + offset > length) {
                        chunkSize = length - offset;
                    }
                    if (lastFragment) {
                        dataOut.write(61);
                    } else {
                        dataOut.write(60);
                    }
                    if (bs != null) {
                        bs.marshal(dataOut);
                    }
                    int commandId = command.getCommandId();
                    if (fragment > 0) {
                        commandId = this.sequenceGenerator.getNextSequenceId();
                    }
                    dataOut.writeInt(commandId);
                    if (bs == null) {
                        dataOut.write(1);
                    }
                    dataOut.writeInt(chunkSize);
                    dataOut.write(data, offset, chunkSize);
                    offset += chunkSize;
                    this.sendWriteBuffer(address, writeBuffer, commandId);
                    ++fragment;
                }
            }
        }
    }

    public int getDatagramSize() {
        return this.datagramSize;
    }

    public void setDatagramSize(int datagramSize) {
        this.datagramSize = datagramSize;
    }

    protected void sendWriteBuffer(SocketAddress address, ByteArrayOutputStream writeBuffer, int commandId) throws IOException {
        byte[] data = writeBuffer.toByteArray();
        this.sendWriteBuffer(commandId, address, data, false);
    }

    protected void sendWriteBuffer(int commandId, SocketAddress address, byte[] data, boolean redelivery) throws IOException {
        ReplayBuffer bufferCache = this.getReplayBuffer();
        if (bufferCache != null && !redelivery) {
            bufferCache.addBuffer(commandId, data);
        }
        if (log.isDebugEnabled()) {
            String text = redelivery ? "REDELIVERING" : "sending";
            log.debug((Object)("Channel: " + this.name + " " + text + " datagram: " + commandId + " to: " + address));
        }
        DatagramPacket packet = new DatagramPacket(data, 0, data.length, address);
        this.channel.send(packet);
    }

    public void sendBuffer(int commandId, Object buffer) throws IOException {
        if (buffer != null) {
            byte[] data = (byte[])buffer;
            this.sendWriteBuffer(commandId, this.replayAddress, data, true);
        } else if (log.isWarnEnabled()) {
            log.warn((Object)("Request for buffer: " + commandId + " is no longer present"));
        }
    }

    protected DatagramPacket createDatagramPacket() {
        return new DatagramPacket(new byte[this.datagramSize], this.datagramSize);
    }

    protected int remaining(ByteArrayOutputStream buffer) {
        return this.datagramSize - buffer.size();
    }

    protected ByteArrayOutputStream createByteArrayOutputStream() {
        return new ByteArrayOutputStream(this.datagramSize);
    }
}

