/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.vm;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicLong;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.Response;
import org.apache.activemq.transport.FutureResponse;
import org.apache.activemq.transport.ResponseCallback;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VMTransport
implements Transport {
    private static final Log log = LogFactory.getLog((Class)VMTransport.class);
    private static final AtomicLong nextId = new AtomicLong(0L);
    protected VMTransport peer;
    protected TransportListener transportListener;
    protected boolean disposed;
    protected boolean marshal;
    protected boolean network;
    protected List queue = Collections.synchronizedList(new LinkedList());
    protected final URI location;
    protected final long id;

    public VMTransport(URI location) {
        this.location = location;
        this.id = nextId.getAndIncrement();
    }

    public synchronized VMTransport getPeer() {
        return this.peer;
    }

    public synchronized void setPeer(VMTransport peer) {
        this.peer = peer;
    }

    public void oneway(Command command) throws IOException {
        if (this.disposed) {
            throw new IOException("Transport disposed.");
        }
        if (this.peer == null) {
            throw new IOException("Peer not connected.");
        }
        if (!this.peer.disposed) {
            TransportListener tl = this.peer.transportListener;
            this.queue = this.peer.queue;
            if (tl != null) {
                tl.onCommand(command);
            } else {
                this.queue.add(command);
            }
        }
    }

    public FutureResponse asyncRequest(Command command, ResponseCallback responseCallback) throws IOException {
        throw new AssertionError((Object)"Unsupported Method");
    }

    public Response request(Command command) throws IOException {
        throw new AssertionError((Object)"Unsupported Method");
    }

    public Response request(Command command, int timeout) throws IOException {
        throw new AssertionError((Object)"Unsupported Method");
    }

    public synchronized TransportListener getTransportListener() {
        return this.transportListener;
    }

    public synchronized void setTransportListener(TransportListener commandListener) {
        this.transportListener = commandListener;
    }

    public synchronized void start() throws Exception {
        if (this.transportListener == null) {
            throw new IOException("TransportListener not set.");
        }
        Iterator iter = this.queue.iterator();
        while (iter.hasNext()) {
            Command command = (Command)iter.next();
            this.transportListener.onCommand(command);
            iter.remove();
        }
    }

    public void stop() throws Exception {
        if (!this.disposed) {
            this.disposed = true;
        }
    }

    public Object narrow(Class target) {
        if (target.isAssignableFrom(this.getClass())) {
            return this;
        }
        return null;
    }

    public boolean isMarshal() {
        return this.marshal;
    }

    public void setMarshal(boolean marshal) {
        this.marshal = marshal;
    }

    public boolean isNetwork() {
        return this.network;
    }

    public void setNetwork(boolean network) {
        this.network = network;
    }

    public String toString() {
        return this.location + "#" + this.id;
    }
}

