/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.xbean;

import java.beans.PropertyEditorManager;
import java.net.URI;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.xbean.XBeanBrokerService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xbean.spring.context.ResourceXmlApplicationContext;
import org.apache.xbean.spring.context.impl.URIEditor;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;

public class BrokerFactoryBean
implements FactoryBean,
InitializingBean,
DisposableBean {
    private static final Log log = LogFactory.getLog((Class)BrokerFactoryBean.class);
    private Resource config;
    private XBeanBrokerService broker;
    private boolean start = false;
    private ResourceXmlApplicationContext context;

    public BrokerFactoryBean() {
    }

    public BrokerFactoryBean(Resource config) {
        this.config = config;
    }

    public Object getObject() throws Exception {
        return this.broker;
    }

    public Class getObjectType() {
        return BrokerService.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.config == null) {
            throw new IllegalArgumentException("config property must be set");
        }
        this.context = new ResourceXmlApplicationContext(this.config);
        try {
            this.broker = (XBeanBrokerService)this.context.getBean("broker");
        }
        catch (BeansException e) {
            // empty catch block
        }
        if (this.broker == null) {
            String[] names = this.context.getBeanNamesForType(BrokerService.class);
            for (int i = 0; i < names.length; ++i) {
                String name = names[i];
                this.broker = (XBeanBrokerService)this.context.getBean(name);
                if (this.broker != null) break;
            }
        }
        if (this.broker == null) {
            throw new IllegalArgumentException("The configuration has no BrokerService instance for resource: " + this.config);
        }
        if (this.start) {
            this.broker.start();
        }
    }

    public void destroy() throws Exception {
        if (this.context != null) {
            this.context.close();
        }
        if (this.broker != null) {
            this.broker.stop();
        }
    }

    public Resource getConfig() {
        return this.config;
    }

    public void setConfig(Resource config) {
        this.config = config;
    }

    public BrokerService getBroker() {
        return this.broker;
    }

    public boolean isStart() {
        return this.start;
    }

    public void setStart(boolean start) {
        this.start = start;
    }

    static {
        PropertyEditorManager.registerEditor(URI.class, URIEditor.class);
    }
}

