/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activeio.adapter;

import java.io.IOException;
import java.net.URI;
import org.apache.activeio.adapter.AsyncToSyncChannel;
import org.apache.activeio.adapter.AsyncToSyncChannelServer;
import org.apache.activeio.adapter.SyncToAsyncChannelFactory;
import org.apache.activeio.packet.async.AsyncChannelFactory;
import org.apache.activeio.packet.sync.SyncChannel;
import org.apache.activeio.packet.sync.SyncChannelFactory;
import org.apache.activeio.packet.sync.SyncChannelServer;

public final class AsyncToSyncChannelFactory
implements SyncChannelFactory {
    private AsyncChannelFactory asyncChannelFactory;

    public static SyncChannelFactory adapt(AsyncChannelFactory channelFactory) {
        if (channelFactory instanceof SyncChannelServer) {
            return (SyncChannelFactory)((Object)channelFactory);
        }
        if (channelFactory.getClass() == SyncToAsyncChannelFactory.class) {
            return ((SyncToAsyncChannelFactory)channelFactory).getSyncChannelFactory();
        }
        return new AsyncToSyncChannelFactory(channelFactory);
    }

    private AsyncToSyncChannelFactory(AsyncChannelFactory asyncChannelFactory) {
        this.asyncChannelFactory = asyncChannelFactory;
    }

    public SyncChannel openSyncChannel(URI location) throws IOException {
        return AsyncToSyncChannel.adapt(this.asyncChannelFactory.openAsyncChannel(location));
    }

    public SyncChannelServer bindSyncChannel(URI location) throws IOException {
        return AsyncToSyncChannelServer.adapt(this.asyncChannelFactory.bindAsyncChannel(location));
    }

    public AsyncChannelFactory getAsyncChannelFactory() {
        return this.asyncChannelFactory;
    }
}

