/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activeio.adapter;

import java.io.IOException;
import java.io.InputStream;
import org.apache.activeio.packet.EOSPacket;
import org.apache.activeio.packet.Packet;
import org.apache.activeio.packet.sync.SyncChannel;

public class SyncChannelToInputStream
extends InputStream {
    private final SyncChannel channel;
    private Packet lastPacket;
    private boolean closed;
    private long timeout = -1L;

    public SyncChannelToInputStream(SyncChannel channel) {
        this.channel = channel;
    }

    public int read() throws IOException {
        do {
            if (this.lastPacket != null) continue;
            try {
                this.lastPacket = this.channel.read(this.timeout);
            }
            catch (IOException e) {
                throw (IOException)new IOException("Channel failed: " + e.getMessage()).initCause(e);
            }
        } while (!this.lastPacket.hasRemaining());
        return this.lastPacket.read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        do {
            if (this.lastPacket == null || !this.lastPacket.hasRemaining()) {
                try {
                    this.lastPacket = this.channel.read(this.timeout);
                }
                catch (IOException e) {
                    throw (IOException)new IOException("Channel failed: " + e.getMessage()).initCause(e);
                }
            }
            if (this.lastPacket != EOSPacket.EOS_PACKET) continue;
            return -1;
        } while (this.lastPacket == null || !this.lastPacket.hasRemaining());
        return this.lastPacket.read(b, off, len);
    }

    public void close() throws IOException {
        this.closed = true;
        super.close();
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setTimeout(long timeout) {
        if (timeout <= 0L) {
            timeout = -1L;
        }
        this.timeout = timeout;
    }

    public long getTimeout() {
        if (this.timeout == -1L) {
            return 0L;
        }
        return this.timeout;
    }
}

