/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activeio.adapter;

import edu.emory.mathcs.backport.java.util.concurrent.CountDownLatch;
import edu.emory.mathcs.backport.java.util.concurrent.Executor;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import java.io.IOException;
import org.apache.activeio.Channel;
import org.apache.activeio.ChannelFactory;
import org.apache.activeio.adapter.AsyncToSyncChannel;
import org.apache.activeio.packet.EOSPacket;
import org.apache.activeio.packet.Packet;
import org.apache.activeio.packet.async.AsyncChannel;
import org.apache.activeio.packet.async.AsyncChannelListener;
import org.apache.activeio.packet.sync.SyncChannel;

public class SyncToAsyncChannel
implements AsyncChannel,
Runnable {
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final SyncChannel syncChannel;
    private final Executor executor;
    private AsyncChannelListener channelListener;
    private CountDownLatch doneCountDownLatch;

    public static AsyncChannel adapt(Channel channel) {
        return SyncToAsyncChannel.adapt(channel, ChannelFactory.DEFAULT_EXECUTOR);
    }

    public static AsyncChannel adapt(Channel channel, Executor executor) {
        if (channel instanceof AsyncChannel) {
            return (AsyncChannel)channel;
        }
        if (channel.getClass() == SyncToAsyncChannel.class) {
            return ((AsyncToSyncChannel)channel).getAsyncChannel();
        }
        return new SyncToAsyncChannel((SyncChannel)channel, executor);
    }

    public SyncToAsyncChannel(SyncChannel syncChannel) {
        this(syncChannel, ChannelFactory.DEFAULT_EXECUTOR);
    }

    public SyncToAsyncChannel(SyncChannel syncChannel, Executor executor) {
        this.syncChannel = syncChannel;
        this.executor = executor;
    }

    public synchronized void start() throws IOException {
        if (this.running.compareAndSet(false, true)) {
            if (this.channelListener == null) {
                throw new IllegalStateException("UpPacketListener must be set before object can be started.");
            }
            this.syncChannel.start();
            this.doneCountDownLatch = new CountDownLatch(1);
            this.executor.execute((Runnable)this);
        }
    }

    public synchronized void stop() throws IOException {
        if (this.running.compareAndSet(true, false)) {
            try {
                this.doneCountDownLatch.await(5L, TimeUnit.SECONDS);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.syncChannel.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        String oldName = Thread.currentThread().getName();
        Thread.currentThread().setName(this.syncChannel.toString());
        try {
            while (this.running.get()) {
                Packet packet;
                block10: {
                    packet = this.syncChannel.read(500L);
                    if (packet == null) continue;
                    if (packet != EOSPacket.EOS_PACKET) break block10;
                    this.channelListener.onPacket(packet);
                    return;
                }
                try {
                    if (!packet.hasRemaining()) continue;
                    this.channelListener.onPacket(packet);
                }
                catch (IOException e) {
                    this.channelListener.onPacketError(e);
                }
                catch (Throwable e) {
                    this.channelListener.onPacketError((IOException)new IOException("Unexpected Error: " + e).initCause(e));
                }
            }
        }
        finally {
            if (this.doneCountDownLatch != null) {
                this.doneCountDownLatch.countDown();
            }
            Thread.currentThread().setName(oldName);
        }
    }

    public void setAsyncChannelListener(AsyncChannelListener channelListener) {
        if (this.running.get()) {
            throw new IllegalStateException("Cannot change the UpPacketListener while the object is running.");
        }
        this.channelListener = channelListener;
    }

    public void write(Packet packet) throws IOException {
        this.syncChannel.write(packet);
    }

    public void flush() throws IOException {
        this.syncChannel.flush();
    }

    public void dispose() {
        try {
            this.stop();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.syncChannel.dispose();
    }

    public AsyncChannelListener getAsyncChannelListener() {
        return this.channelListener;
    }

    public Object getAdapter(Class target) {
        if (target.isAssignableFrom(this.getClass())) {
            return this;
        }
        return this.syncChannel.getAdapter(target);
    }

    public SyncChannel getSynchChannel() {
        return this.syncChannel;
    }

    public String toString() {
        return this.syncChannel.toString();
    }
}

