/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activeio.adapter;

import edu.emory.mathcs.backport.java.util.concurrent.CountDownLatch;
import edu.emory.mathcs.backport.java.util.concurrent.Executor;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import java.io.IOException;
import java.net.URI;
import org.apache.activeio.AcceptListener;
import org.apache.activeio.Channel;
import org.apache.activeio.ChannelFactory;
import org.apache.activeio.ChannelServer;
import org.apache.activeio.adapter.AsyncToSyncChannelServer;
import org.apache.activeio.adapter.SyncToAsyncChannel;
import org.apache.activeio.packet.async.AsyncChannelServer;
import org.apache.activeio.packet.sync.SyncChannelServer;

public final class SyncToAsyncChannelServer
implements AsyncChannelServer,
Runnable {
    private final SyncChannelServer syncChannelServer;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final Executor executor;
    private AcceptListener acceptListener;
    private CountDownLatch doneCountDownLatch;

    public static AsyncChannelServer adapt(ChannelServer channel) {
        return SyncToAsyncChannelServer.adapt(channel, ChannelFactory.DEFAULT_EXECUTOR);
    }

    public static AsyncChannelServer adapt(ChannelServer channel, Executor executor) {
        if (channel instanceof AsyncChannelServer) {
            return (AsyncChannelServer)channel;
        }
        if (channel.getClass() == SyncToAsyncChannel.class) {
            return ((AsyncToSyncChannelServer)channel).getAsyncChannelServer();
        }
        return new SyncToAsyncChannelServer((SyncChannelServer)channel, executor);
    }

    public SyncToAsyncChannelServer(SyncChannelServer syncServer) {
        this(syncServer, ChannelFactory.DEFAULT_EXECUTOR);
    }

    public SyncToAsyncChannelServer(SyncChannelServer syncServer, Executor executor) {
        this.syncChannelServer = syncServer;
        this.executor = executor;
    }

    public synchronized void start() throws IOException {
        if (this.running.compareAndSet(false, true)) {
            if (this.acceptListener == null) {
                throw new IllegalStateException("AcceptListener must be set before object can be started.");
            }
            this.syncChannelServer.start();
            this.doneCountDownLatch = new CountDownLatch(1);
            this.executor.execute((Runnable)this);
        }
    }

    public synchronized void stop() throws IOException {
        if (this.running.compareAndSet(true, false)) {
            try {
                this.doneCountDownLatch.await(5L, TimeUnit.SECONDS);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.syncChannelServer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        String oldName = Thread.currentThread().getName();
        Thread.currentThread().setName(this.syncChannelServer.toString());
        try {
            while (this.running.get()) {
                try {
                    Channel channel = this.syncChannelServer.accept(500L);
                    if (channel == null) continue;
                    this.acceptListener.onAccept(channel);
                }
                catch (IOException e) {
                    if (!this.running.get()) continue;
                    this.acceptListener.onAcceptError(e);
                }
                catch (Throwable e) {
                    if (!this.running.get()) continue;
                    this.acceptListener.onAcceptError((IOException)new IOException("Unexpected Error: " + e).initCause(e));
                }
            }
        }
        finally {
            if (this.doneCountDownLatch != null) {
                this.doneCountDownLatch.countDown();
            }
            Thread.currentThread().setName(oldName);
        }
    }

    public void setAcceptListener(AcceptListener acceptListener) {
        if (this.running.get()) {
            throw new IllegalStateException("Cannot change the AcceptListener while the object is running.");
        }
        this.acceptListener = acceptListener;
    }

    public void dispose() {
        try {
            this.stop();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.syncChannelServer.dispose();
    }

    public URI getBindURI() {
        return this.syncChannelServer.getBindURI();
    }

    public URI getConnectURI() {
        return this.syncChannelServer.getConnectURI();
    }

    public SyncChannelServer getSynchChannelServer() {
        return this.syncChannelServer;
    }

    public Object getAdapter(Class target) {
        if (target.isAssignableFrom(this.getClass())) {
            return this;
        }
        return this.syncChannelServer.getAdapter(target);
    }

    public String toString() {
        return this.syncChannelServer.toString();
    }
}

