/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activeio.command;

import java.io.EOFException;
import java.io.IOException;
import org.apache.activeio.command.AsyncCommandChannel;
import org.apache.activeio.command.CommandListener;
import org.apache.activeio.command.WireFormat;
import org.apache.activeio.packet.EOSPacket;
import org.apache.activeio.packet.Packet;
import org.apache.activeio.packet.async.AsyncChannel;
import org.apache.activeio.packet.async.AsyncChannelListener;

public class AsyncChannelToAsyncCommandChannel
implements AsyncCommandChannel {
    private AsyncChannel channel;
    private WireFormat wireFormat;

    public AsyncChannelToAsyncCommandChannel(AsyncChannel channel, WireFormat wireFormat) {
        this.channel = channel;
        this.wireFormat = wireFormat;
    }

    public void writeCommand(Object command) throws IOException {
        this.channel.write(this.wireFormat.marshal(command));
        this.channel.flush();
    }

    public Object getAdapter(Class target) {
        return this.channel.getAdapter(target);
    }

    public void dispose() {
        this.channel.dispose();
    }

    public void start() throws IOException {
        this.channel.start();
    }

    public void stop() throws IOException {
        this.channel.stop();
    }

    public void setCommandListener(final CommandListener listener) {
        this.channel.setAsyncChannelListener(new AsyncChannelListener(){

            public void onPacket(Packet packet) {
                if (packet == EOSPacket.EOS_PACKET) {
                    listener.onError(new EOFException("Peer disconnected."));
                    return;
                }
                try {
                    Object command = AsyncChannelToAsyncCommandChannel.this.wireFormat.unmarshal(packet);
                    listener.onCommand(command);
                }
                catch (IOException e) {
                    listener.onError(e);
                }
            }

            public void onPacketError(IOException error) {
                listener.onError(error);
            }
        });
    }
}

