/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activeio.command;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import org.apache.activeio.adapter.PacketToInputStream;
import org.apache.activeio.command.ClassLoadingAwareObjectInputStream;
import org.apache.activeio.command.WireFormat;
import org.apache.activeio.packet.ByteArrayPacket;
import org.apache.activeio.packet.Packet;
import org.apache.activeio.util.ByteArrayOutputStream;

public class DefaultWireFormat
implements WireFormat {
    public Packet marshal(Object command) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream ds = new DataOutputStream(baos);
        this.marshal(command, ds);
        ds.close();
        return new ByteArrayPacket(baos.toByteSequence());
    }

    public Object unmarshal(Packet packet) throws IOException {
        return this.unmarshal(new DataInputStream(new PacketToInputStream(packet)));
    }

    public void marshal(Object command, DataOutputStream ds) throws IOException {
        ObjectOutputStream out = new ObjectOutputStream(ds);
        out.writeObject(command);
        out.flush();
        out.reset();
    }

    public Object unmarshal(DataInputStream ds) throws IOException {
        try {
            ClassLoadingAwareObjectInputStream in = new ClassLoadingAwareObjectInputStream(ds);
            Object command = in.readObject();
            in.close();
            return command;
        }
        catch (ClassNotFoundException e) {
            throw (IOException)new IOException("unmarshal failed: " + e).initCause(e);
        }
    }

    public void setVersion(int version) {
    }

    public int getVersion() {
        return 0;
    }
}

