/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activeio.journal.active;

import edu.emory.mathcs.backport.java.util.concurrent.BlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.Callable;
import edu.emory.mathcs.backport.java.util.concurrent.ExecutionException;
import edu.emory.mathcs.backport.java.util.concurrent.FutureTask;
import edu.emory.mathcs.backport.java.util.concurrent.LinkedBlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadFactory;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadPoolExecutor;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import org.apache.activeio.journal.InvalidRecordLocationException;
import org.apache.activeio.journal.Journal;
import org.apache.activeio.journal.JournalEventListener;
import org.apache.activeio.journal.RecordLocation;
import org.apache.activeio.journal.active.BatchedWrite;
import org.apache.activeio.journal.active.Location;
import org.apache.activeio.journal.active.LogFileManager;
import org.apache.activeio.journal.active.Record;
import org.apache.activeio.packet.ByteArrayPacket;
import org.apache.activeio.packet.ByteBufferPacketPool;
import org.apache.activeio.packet.Packet;

public final class JournalImpl
implements Journal {
    public static final int DEFAULT_POOL_SIZE = Integer.parseInt(System.getProperty("org.apache.activeio.journal.active.DefaultPoolSize", "5"));
    public static final int DEFAULT_PACKET_SIZE = Integer.parseInt(System.getProperty("org.apache.activeio.journal.active.DefaultPacketSize", "4194304"));
    private static final int OVERFLOW_RENOTIFICATION_DELAY = 500;
    private static ByteBufferPacketPool lastPool;
    private boolean disposed = false;
    private int appendLogFileId = 0;
    private int appendLogFileOffset = 0;
    private BatchedWrite pendingBatchWrite;
    private Location lastMarkedLocation;
    private LogFileManager file;
    private ThreadPoolExecutor executor;
    private int rolloverFence;
    private JournalEventListener eventListener;
    private ByteBufferPacketPool packetPool;
    private long overflowNotificationTime = System.currentTimeMillis();
    private Packet markPacket = new ByteArrayPacket(new byte[8]);

    public JournalImpl(File logDirectory) throws IOException {
        this(new LogFileManager(logDirectory));
    }

    public JournalImpl(File logDirectory, int logFileCount, int logFileSize) throws IOException {
        this(new LogFileManager(logDirectory, logFileCount, logFileSize, null));
    }

    public JournalImpl(File logDirectory, int logFileCount, int logFileSize, File archiveDirectory) throws IOException {
        this(new LogFileManager(logDirectory, logFileCount, logFileSize, archiveDirectory));
    }

    public JournalImpl(LogFileManager logFile) {
        this.file = logFile;
        this.packetPool = JournalImpl.createBufferPool();
        this.executor = new ThreadPoolExecutor(1, 1, 30L, TimeUnit.SECONDS, (BlockingQueue)new LinkedBlockingQueue(), new ThreadFactory(){

            public Thread newThread(Runnable runnable) {
                Thread answer = new Thread(runnable, "Journal Writer");
                answer.setPriority(10);
                answer.setDaemon(true);
                return answer;
            }
        });
        this.executor.allowCoreThreadTimeOut(true);
        this.lastMarkedLocation = this.file.getLastMarkedRecordLocation();
        Location nextAppendLocation = this.file.getNextAppendLocation();
        this.appendLogFileId = nextAppendLocation.getLogFileId();
        this.appendLogFileOffset = nextAppendLocation.getLogFileOffset();
        this.rolloverFence = this.file.getInitialLogFileSize() / 10 * 9;
    }

    private static synchronized ByteBufferPacketPool createBufferPool() {
        if (lastPool != null) {
            ByteBufferPacketPool rc = lastPool;
            lastPool = null;
            return rc;
        }
        return new ByteBufferPacketPool(DEFAULT_POOL_SIZE, DEFAULT_PACKET_SIZE);
    }

    private static synchronized void disposeBufferPool(ByteBufferPacketPool pool) {
        if (lastPool != null) {
            pool.dispose();
        } else {
            pool.waitForPacketsToReturn();
            lastPool = pool;
        }
    }

    public RecordLocation write(Packet data, boolean sync) throws IOException {
        return this.write((byte)1, data, sync, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Location write(byte recordType, Packet data, boolean sync, Location mark) throws IOException {
        try {
            BatchedWrite writeCommand;
            Location location;
            Record record = new Record(recordType, data, mark);
            JournalImpl journalImpl = this;
            synchronized (journalImpl) {
                if (this.disposed) {
                    throw new IOException("Journal has been closed.");
                }
                location = new Location(this.appendLogFileId, this.appendLogFileOffset);
                record.setLocation(location);
                writeCommand = this.addToPendingWriteBatch(record, mark, sync);
                this.appendLogFileOffset += data.limit() + 36;
                this.rolloverCheck();
            }
            if (sync) {
                writeCommand.waitForForce();
            }
            return location;
        }
        catch (IOException e) {
            throw e;
        }
        catch (InterruptedException e) {
            throw (IOException)new InterruptedIOException().initCause(e);
        }
        catch (Throwable e) {
            throw (IOException)new IOException("Write failed: " + e).initCause(e);
        }
    }

    private BatchedWrite addToPendingWriteBatch(Record record, Location mark, boolean force) throws InterruptedException {
        BatchedWrite answer = null;
        while (record.hasRemaining()) {
            boolean full;
            boolean queueTheWrite = false;
            if (this.pendingBatchWrite == null) {
                this.pendingBatchWrite = new BatchedWrite(this.packetPool.getPacket());
                queueTheWrite = true;
            }
            answer = this.pendingBatchWrite;
            boolean bl = full = !this.pendingBatchWrite.append(record, mark, force);
            if (queueTheWrite) {
                final BatchedWrite queuedWrite = this.pendingBatchWrite;
                this.executor.execute(new Runnable(){

                    public void run() {
                        try {
                            JournalImpl.this.queuedWrite(queuedWrite);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                });
            }
            if (!full) continue;
            this.pendingBatchWrite = null;
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queuedWrite(BatchedWrite write) throws InterruptedException {
        write.flip();
        try {
            this.file.append(write);
            write.forced();
        }
        catch (Throwable e) {
            write.writeFailed(e);
        }
        finally {
            write.getPacket().dispose();
        }
    }

    private void rolloverCheck() throws IOException {
        if (this.eventListener != null && this.file.isPastHalfActive() && this.overflowNotificationTime + 500L < System.currentTimeMillis()) {
            Location safeSpot = this.file.getFirstRecordLocationOfSecondActiveLogFile();
            this.eventListener.overflowNotification(safeSpot);
            this.overflowNotificationTime = System.currentTimeMillis();
        }
        if (this.appendLogFileOffset > this.rolloverFence) {
            if (!this.file.canActivateNextLogFile()) {
                this.overflowNotificationTime -= 500L;
            } else {
                try {
                    FutureTask result = new FutureTask(new Callable(){

                        public Object call() throws Exception {
                            return JournalImpl.this.queuedActivateNextLogFile();
                        }
                    });
                    this.executor.execute((Runnable)result);
                    Location location = (Location)result.get();
                    this.appendLogFileId = location.getLogFileId();
                    this.appendLogFileOffset = location.getLogFileOffset();
                }
                catch (InterruptedException e) {
                    throw (IOException)new IOException("Interrupted.").initCause(e);
                }
                catch (ExecutionException e) {
                    throw this.handleExecutionException(e);
                }
            }
        }
    }

    private Location queuedActivateNextLogFile() throws IOException {
        this.file.activateNextLogFile();
        return this.file.getNextAppendLocation();
    }

    public synchronized void setMark(RecordLocation l, boolean force) throws InvalidRecordLocationException, IOException {
        Location location = (Location)l;
        if (location == null) {
            throw new InvalidRecordLocationException("The location cannot be null.");
        }
        if (this.lastMarkedLocation != null && location.compareTo(this.lastMarkedLocation) < 0) {
            throw new InvalidRecordLocationException("The location is less than the last mark.");
        }
        this.markPacket.clear();
        location.writeToPacket(this.markPacket);
        this.markPacket.flip();
        this.write((byte)2, this.markPacket, force, location);
        this.lastMarkedLocation = location;
    }

    public RecordLocation getMark() {
        return this.lastMarkedLocation;
    }

    public RecordLocation getNextRecordLocation(final RecordLocation lastLocation) throws IOException, InvalidRecordLocationException {
        if (lastLocation == null) {
            if (this.lastMarkedLocation != null) {
                return this.lastMarkedLocation;
            }
            return this.file.getFirstActiveLogLocation();
        }
        try {
            FutureTask result = new FutureTask(new Callable(){

                public Object call() throws Exception {
                    return JournalImpl.this.queuedGetNextRecordLocation((Location)lastLocation);
                }
            });
            this.executor.execute((Runnable)result);
            return (Location)result.get();
        }
        catch (InterruptedException e) {
            throw (IOException)new IOException("Interrupted.").initCause(e);
        }
        catch (ExecutionException e) {
            throw this.handleExecutionException(e);
        }
    }

    protected IOException handleExecutionException(ExecutionException e) throws IOException {
        Throwable cause = e.getCause();
        if (cause instanceof IOException) {
            return (IOException)cause;
        }
        return (IOException)new IOException(cause.getMessage()).initCause(cause);
    }

    private Location queuedGetNextRecordLocation(Location location) throws IOException, InvalidRecordLocationException {
        return this.file.getNextDataRecordLocation(location);
    }

    public Packet read(RecordLocation l) throws IOException, InvalidRecordLocationException {
        final Location location = (Location)l;
        try {
            FutureTask result = new FutureTask(new Callable(){

                public Object call() throws Exception {
                    return JournalImpl.this.file.readPacket(location);
                }
            });
            this.executor.execute((Runnable)result);
            return (Packet)result.get();
        }
        catch (InterruptedException e) {
            throw (IOException)new IOException("Interrupted.").initCause(e);
        }
        catch (ExecutionException e) {
            throw this.handleExecutionException(e);
        }
    }

    public void setJournalEventListener(JournalEventListener eventListener) {
        this.eventListener = eventListener;
    }

    public void close() throws IOException {
        this.dispose();
    }

    public void dispose() {
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        this.executor.shutdown();
        this.file.dispose();
        ByteBufferPacketPool pool = this.packetPool;
        this.packetPool = null;
        JournalImpl.disposeBufferPool(pool);
    }

    public File getLogDirectory() {
        return this.file.getLogDirectory();
    }

    public int getInitialLogFileSize() {
        return this.file.getInitialLogFileSize();
    }

    public String toString() {
        return "Active Journal: using " + this.file.getOnlineLogFileCount() + " x " + (float)this.file.getInitialLogFileSize() / 1048576.0f + " Megs at: " + this.getLogDirectory();
    }
}

