/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activeio.packet.async.filter;

import edu.emory.mathcs.backport.java.util.concurrent.BlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.CountDownLatch;
import edu.emory.mathcs.backport.java.util.concurrent.Executor;
import edu.emory.mathcs.backport.java.util.concurrent.LinkedBlockingDeque;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadPoolExecutor;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicInteger;
import java.io.IOException;
import java.io.InterruptedIOException;
import org.apache.activeio.ChannelFactory;
import org.apache.activeio.packet.Packet;
import org.apache.activeio.packet.async.AsyncChannel;
import org.apache.activeio.packet.async.FilterAsyncChannel;

public class AsyncWriteAsyncChannel
extends FilterAsyncChannel {
    private final ObjectDispatcher dispatcher;
    private static final Object FLUSH_COMMAND = new Object();

    public AsyncWriteAsyncChannel(AsyncChannel next) {
        this(next, 10);
    }

    public AsyncWriteAsyncChannel(AsyncChannel next, int queueSize) {
        super(next);
        this.dispatcher = new ObjectDispatcher(this, queueSize);
    }

    public void onObject(Object o) {
        try {
            if (o == FLUSH_COMMAND) {
                this.next.flush();
                return;
            }
            if (o.getClass() == CountDownLatch.class) {
                this.next.flush();
                ((CountDownLatch)o).countDown();
                return;
            }
            this.next.write((Packet)o);
        }
        catch (IOException e) {
            this.channelListener.onPacketError(e);
        }
    }

    public void write(Packet packet) throws IOException {
        try {
            this.dispatcher.add(packet);
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
    }

    public void flush() throws IOException {
        this.flush(0L);
    }

    public void stop() throws IOException {
        this.flush(-1L);
    }

    private void flush(long timeout) throws InterruptedIOException {
        try {
            if (timeout == 0L) {
                this.dispatcher.add(FLUSH_COMMAND);
            } else if (timeout == -1L) {
                CountDownLatch l = new CountDownLatch(1);
                this.dispatcher.add(l);
                l.await();
            } else {
                CountDownLatch l = new CountDownLatch(1);
                this.dispatcher.add(l);
                l.await(timeout, TimeUnit.MILLISECONDS);
            }
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
    }

    public static class ObjectDispatcher {
        private final ThreadPoolExecutor executor;
        private final AsyncWriteAsyncChannel objectListener;

        public ObjectDispatcher(AsyncWriteAsyncChannel objectListener) {
            this(objectListener, 10);
        }

        public ObjectDispatcher(AsyncWriteAsyncChannel objectListener, int queueSize) {
            this.objectListener = objectListener;
            this.executor = new ThreadPoolExecutor(1, 1, 1L, TimeUnit.SECONDS, (BlockingQueue)new LinkedBlockingDeque(queueSize));
        }

        public void add(final Object o) throws InterruptedException {
            this.executor.execute(new Runnable(){

                public void run() {
                    ObjectDispatcher.this.objectListener.onObject(o);
                }
            });
        }
    }

    public static class ObjectDispatcherX
    implements Runnable {
        private final Executor executor;
        private final BlockingQueue queue;
        private final AtomicInteger size = new AtomicInteger(0);
        private final AsyncWriteAsyncChannel objectListener;
        private long pollDelay = 10L;

        public ObjectDispatcherX(AsyncWriteAsyncChannel objectListener) {
            this(objectListener, 10);
        }

        public ObjectDispatcherX(AsyncWriteAsyncChannel objectListener, int queueSize) {
            this(objectListener, ChannelFactory.DEFAULT_EXECUTOR, (BlockingQueue)new LinkedBlockingDeque(queueSize));
        }

        public ObjectDispatcherX(AsyncWriteAsyncChannel objectListener, Executor executor, BlockingQueue queue) {
            this.objectListener = objectListener;
            this.executor = executor;
            this.queue = queue;
        }

        public void add(Object o) throws InterruptedException {
            int t = this.size.incrementAndGet();
            this.queue.put(o);
            if (t == 1) {
                this.executor.execute((Runnable)this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void run() {
            int t = this.size.get();
            while (t > 0) {
                int count = 0;
                try {
                    Object o;
                    while ((o = this.queue.poll(this.pollDelay, TimeUnit.MILLISECONDS)) != null) {
                        ++count;
                        this.objectListener.onObject(o);
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
                finally {
                    t = this.size.addAndGet(-count);
                }
            }
        }
    }
}

