/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activeio.packet.async.filter;

import java.io.IOException;
import org.apache.activeio.packet.Packet;
import org.apache.activeio.packet.async.AsyncChannel;
import org.apache.activeio.packet.async.FilterAsyncChannel;
import org.apache.activeio.util.PacketAggregator;

public final class PacketAggregatingAsyncChannel
extends FilterAsyncChannel {
    private final PacketAggregator aggregator = new PacketAggregator(){

        protected void packetAssembled(Packet packet) {
            PacketAggregatingAsyncChannel.this.getAsyncChannelListener().onPacket(packet);
        }
    };

    public PacketAggregatingAsyncChannel(AsyncChannel next) {
        super(next);
    }

    public void onPacket(Packet packet) {
        try {
            this.aggregator.addRawPacket(packet);
        }
        catch (IOException e) {
            this.getAsyncChannelListener().onPacketError(e);
        }
    }

    public void write(Packet packet) throws IOException {
        this.getNext().write(this.aggregator.getHeader(packet));
        this.getNext().write(packet);
    }
}

