/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activeio.packet.async.filter;

import java.io.IOException;
import org.apache.activeio.packet.ByteArrayPacket;
import org.apache.activeio.packet.Packet;
import org.apache.activeio.packet.async.AsyncChannel;
import org.apache.activeio.packet.async.FilterAsyncChannel;

public class WriteBufferedAsyncChannel
extends FilterAsyncChannel {
    private static final int DEFAULT_BUFFER_SIZE = 65536;
    private final Packet buffer;
    private final boolean enableDirectWrites;

    public WriteBufferedAsyncChannel(AsyncChannel channel) {
        this(channel, new ByteArrayPacket(new byte[65536]));
    }

    public WriteBufferedAsyncChannel(AsyncChannel channel, Packet buffer) {
        this(channel, buffer, true);
    }

    public WriteBufferedAsyncChannel(AsyncChannel channel, Packet buffer, boolean enableDirectWrites) {
        super(channel);
        this.buffer = buffer;
        this.enableDirectWrites = enableDirectWrites;
    }

    public void write(Packet packet) throws IOException {
        while (packet.hasRemaining()) {
            packet.read(this.buffer);
            if (this.buffer.hasRemaining()) continue;
            this.flush();
            if (!this.enableDirectWrites || packet.remaining() <= this.buffer.capacity()) continue;
            this.getNext().write(packet);
            return;
        }
    }

    public void flush() throws IOException {
        this.buffer.flip();
        this.getNext().write(this.buffer);
        this.buffer.clear();
    }
}

