/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activeio.packet.async.vmpipe;

import edu.emory.mathcs.backport.java.util.concurrent.Semaphore;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import java.io.IOException;
import java.io.InterruptedIOException;
import org.apache.activeio.packet.EOSPacket;
import org.apache.activeio.packet.Packet;
import org.apache.activeio.packet.async.AsyncChannel;
import org.apache.activeio.packet.async.AsyncChannelListener;

public final class VMPipeAsyncChannelPipe {
    final PipeChannel leftChannel = new PipeChannel();
    final PipeChannel rightChannel = new PipeChannel();

    public VMPipeAsyncChannelPipe() {
        this.leftChannel.setSibiling(this.rightChannel);
        this.rightChannel.setSibiling(this.leftChannel);
    }

    public AsyncChannel getLeftAsyncChannel() {
        return this.leftChannel;
    }

    public AsyncChannel getRightAsyncChannel() {
        return this.rightChannel;
    }

    public static final class PipeChannel
    implements AsyncChannel {
        private PipeChannel sibiling;
        private AsyncChannelListener channelListener;
        private final Semaphore runMutext = new Semaphore(0);
        private boolean disposed;
        private boolean running;

        public void setAsyncChannelListener(AsyncChannelListener channelListener) {
            this.channelListener = channelListener;
        }

        public AsyncChannelListener getAsyncChannelListener() {
            return this.channelListener;
        }

        public void write(Packet packet) throws IOException {
            if (this.disposed) {
                throw new IOException("Conneciton closed.");
            }
            this.sibiling.onPacket(packet, -1L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onPacket(Packet packet, long timeout) throws IOException {
            try {
                if (timeout == 0L) {
                    if (!this.runMutext.tryAcquire(0L, TimeUnit.MILLISECONDS)) {
                        return;
                    }
                } else if (timeout == -1L) {
                    this.runMutext.acquire();
                } else if (!this.runMutext.tryAcquire(timeout, TimeUnit.MILLISECONDS)) {
                    return;
                }
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException();
            }
            try {
                if (this.disposed) {
                    throw new IOException("Peer connection closed.");
                }
                this.channelListener.onPacket(packet);
            }
            finally {
                this.runMutext.release();
            }
        }

        public void flush() throws IOException {
        }

        public void start() throws IOException {
            if (this.running) {
                return;
            }
            if (this.channelListener == null) {
                throw new IOException("channelListener has not been set.");
            }
            this.running = true;
            this.runMutext.release();
        }

        public void stop() throws IOException {
            if (!this.running) {
                return;
            }
            try {
                this.runMutext.tryAcquire(5L, TimeUnit.SECONDS);
                this.running = false;
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException();
            }
        }

        public void dispose() {
            if (this.disposed) {
                return;
            }
            if (this.running && this.channelListener != null) {
                this.channelListener.onPacketError(new IOException("Pipe closed."));
                this.running = false;
            }
            this.disposed = true;
            this.runMutext.release();
            try {
                this.sibiling.onPacket(EOSPacket.EOS_PACKET, 0L);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public PipeChannel getSibiling() {
            return this.sibiling;
        }

        public void setSibiling(PipeChannel sibiling) {
            this.sibiling = sibiling;
        }

        public Object getAdapter(Class target) {
            if (target.isAssignableFrom(this.getClass())) {
                return this;
            }
            return null;
        }

        public String getId() {
            return "0x" + Integer.toHexString(System.identityHashCode(this));
        }

        public String toString() {
            return "Pipe Channel from " + this.getId() + " to " + this.sibiling.getId();
        }
    }
}

