/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activeio.packet.sync.datagram;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.URI;
import org.apache.activeio.packet.sync.SyncChannel;
import org.apache.activeio.packet.sync.SyncChannelFactory;
import org.apache.activeio.packet.sync.SyncChannelServer;
import org.apache.activeio.packet.sync.datagram.DatagramSocketSyncChannel;

public class DatagramSocketSyncChannelFactory
implements SyncChannelFactory {
    public SyncChannel openSyncChannel(URI location) throws IOException {
        DatagramSocket socket = null;
        socket = new DatagramSocket();
        if (location != null) {
            InetAddress address = InetAddress.getByName(location.getHost());
            socket.connect(address, location.getPort());
        }
        return this.createSyncChannel(socket);
    }

    public SyncChannel openSyncChannel(URI location, URI localLocation) throws IOException {
        DatagramSocket socket = null;
        InetAddress address = InetAddress.getByName(localLocation.getHost());
        socket = new DatagramSocket(localLocation.getPort(), address);
        if (location != null) {
            address = InetAddress.getByName(location.getHost());
            socket.connect(address, location.getPort());
        }
        return this.createSyncChannel(socket);
    }

    protected SyncChannel createSyncChannel(DatagramSocket socket) throws IOException {
        return new DatagramSocketSyncChannel(socket);
    }

    public SyncChannelServer bindSyncChannel(URI location) throws IOException {
        throw new IOException("A SynchChannelServer is not available for this channel.");
    }
}

