/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activeio.packet.sync.filter;

import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.locks.Lock;
import edu.emory.mathcs.backport.java.util.concurrent.locks.ReentrantLock;
import java.io.IOException;
import java.io.InterruptedIOException;
import org.apache.activeio.packet.Packet;
import org.apache.activeio.packet.sync.FilterSyncChannel;
import org.apache.activeio.packet.sync.SyncChannel;

public class SynchornizedSyncChannel
extends FilterSyncChannel {
    private final Lock readLock;
    private final Lock writeLock;

    public SynchornizedSyncChannel(SyncChannel next) {
        this(next, (Lock)new ReentrantLock(), (Lock)new ReentrantLock());
    }

    public SynchornizedSyncChannel(SyncChannel next, Lock readLock, Lock writeLock) {
        super(next);
        this.readLock = readLock;
        this.writeLock = writeLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Packet read(long timeout) throws IOException {
        try {
            if (timeout == -1L) {
                this.readLock.lock();
            } else {
                long start = System.currentTimeMillis();
                if (!this.readLock.tryLock(0L, TimeUnit.MILLISECONDS)) {
                    return null;
                }
                timeout = Math.max(0L, timeout - (System.currentTimeMillis() - start));
            }
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException(e.getMessage());
        }
        try {
            Packet packet = this.getNext().read(timeout);
            return packet;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Packet packet) throws IOException {
        this.writeLock.lock();
        try {
            this.getNext().write(packet);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        this.writeLock.lock();
        try {
            this.getNext().flush();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public synchronized Object getAdapter(Class target) {
        return super.getAdapter(target);
    }

    public synchronized void start() throws IOException {
        super.start();
    }

    public synchronized void stop() throws IOException {
        super.stop();
    }

    public Lock getReadLock() {
        return this.readLock;
    }

    public Lock getWriteLock() {
        return this.writeLock;
    }
}

