/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activeio.packet.sync.multicast;

import java.io.IOException;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.URI;
import org.apache.activeio.packet.sync.SyncChannel;
import org.apache.activeio.packet.sync.SyncChannelFactory;
import org.apache.activeio.packet.sync.SyncChannelServer;
import org.apache.activeio.packet.sync.multicast.MulticastSocketSyncChannel;

public class MulticastSocketSyncChannelFactory
implements SyncChannelFactory {
    public SyncChannel openSyncChannel(URI groupURI) throws IOException {
        if (groupURI == null) {
            throw new IllegalArgumentException("group URI cannot be null");
        }
        MulticastSocket socket = new MulticastSocket(groupURI.getPort());
        return this.createSyncChannel(socket, InetAddress.getByName(groupURI.getHost()));
    }

    public SyncChannel openSyncChannel(URI groupURI, URI localLocation) throws IOException {
        if (groupURI == null) {
            throw new IllegalArgumentException("group URI cannot be null");
        }
        MulticastSocket socket = new MulticastSocket(groupURI.getPort());
        if (localLocation != null) {
            socket.setInterface(InetAddress.getByName(localLocation.getHost()));
        }
        return this.createSyncChannel(socket, InetAddress.getByName(groupURI.getHost()));
    }

    protected SyncChannel createSyncChannel(MulticastSocket socket, InetAddress groupAddress) throws IOException {
        return new MulticastSocketSyncChannel(socket, groupAddress);
    }

    public SyncChannelServer bindSyncChannel(URI location) throws IOException {
        throw new IOException("A SyncChannelServer is not available for this channel.");
    }
}

