/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activeio.packet.sync.socket;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.URI;
import org.apache.activeio.Channel;
import org.apache.activeio.packet.sync.SyncChannelServer;
import org.apache.activeio.packet.sync.socket.SocketSyncChannel;
import org.apache.activeio.stream.sync.socket.SocketStreamChannel;
import org.apache.activeio.stream.sync.socket.SocketStreamChannelServer;

public class SocketSyncChannelServer
implements SyncChannelServer {
    private final SocketStreamChannelServer server;

    public SocketSyncChannelServer(SocketStreamChannelServer server) {
        this.server = server;
    }

    public SocketSyncChannelServer(ServerSocket socket, URI bindURI, URI connectURI) {
        this(new SocketStreamChannelServer(socket, bindURI, connectURI));
    }

    public Channel accept(long timeout) throws IOException {
        Channel channel = this.server.accept(timeout);
        if (channel != null) {
            channel = this.createChannel((SocketStreamChannel)channel);
        }
        return channel;
    }

    protected Channel createChannel(SocketStreamChannel channel) throws IOException {
        return new SocketSyncChannel(channel);
    }

    public void dispose() {
        this.server.dispose();
    }

    public URI getBindURI() {
        return this.server.getBindURI();
    }

    public URI getConnectURI() {
        return this.server.getConnectURI();
    }

    public void start() throws IOException {
        this.server.start();
    }

    public void stop() throws IOException {
        this.server.stop();
    }

    public Object getAdapter(Class target) {
        if (target.isAssignableFrom(this.getClass())) {
            return this;
        }
        return this.server.getAdapter(target);
    }

    public String toString() {
        return this.server.toString();
    }
}

