/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activeio.util;

import java.io.IOException;
import org.apache.activeio.packet.AppendedPacket;
import org.apache.activeio.packet.ByteArrayPacket;
import org.apache.activeio.packet.EOSPacket;
import org.apache.activeio.packet.Packet;
import org.apache.activeio.packet.PacketData;

public abstract class PacketAggregator {
    private static final int HEADER_LENGTH = 4;
    private final ByteArrayPacket headerBuffer = new ByteArrayPacket(new byte[4]);
    private final PacketData headerData = new PacketData(this.headerBuffer);
    Packet incompleteUpPacket;
    boolean headerLoaded;
    private int upPacketLength;

    public void addRawPacket(Packet packet) throws IOException {
        if (packet == EOSPacket.EOS_PACKET) {
            this.packetAssembled(packet);
            return;
        }
        if (this.incompleteUpPacket != null) {
            packet = AppendedPacket.join(this.incompleteUpPacket, packet);
            this.incompleteUpPacket = null;
        }
        while (true) {
            if (!this.headerLoaded) {
                boolean bl = this.headerLoaded = packet.remaining() >= 4;
                if (this.headerLoaded) {
                    PacketData data = new PacketData(packet);
                    this.upPacketLength = data.readInt();
                    if (this.upPacketLength < 0) {
                        throw new IOException("Up packet lenth was invalid: " + this.upPacketLength);
                    }
                    packet = packet.slice();
                }
                if (!this.headerLoaded) break;
            }
            if (packet.remaining() < this.upPacketLength) break;
            int origLimit = packet.limit();
            packet.limit(this.upPacketLength);
            this.packetAssembled(packet.slice());
            packet.position(this.upPacketLength);
            packet.limit(origLimit);
            packet = packet.slice();
            this.headerLoaded = false;
        }
        if (packet.hasRemaining()) {
            this.incompleteUpPacket = packet;
        }
    }

    protected abstract void packetAssembled(Packet var1);

    public Packet getHeader(Packet packet) throws IOException {
        this.headerBuffer.clear();
        this.headerData.writeInt(packet.remaining());
        this.headerBuffer.flip();
        return this.headerBuffer;
    }
}

