/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.mail.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.geronimo.mail.util.SessionUtil;

public class ASCIIUtil {
    private static final String MIME_FOLDTEXT = "mail.mime.foldtext";
    private static final int FOLD_THRESHOLD = 76;

    public static boolean isAscii(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (ASCIIUtil.isAscii(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isAscii(int ch) {
        if (ch == 13 || ch == 10 || ch == 9) {
            return true;
        }
        return ch < 127 && ch >= 32;
    }

    public static String getTextTransferEncoding(InputStream content) throws IOException {
        int ch;
        BufferedInputStream in = new BufferedInputStream(content, 4096);
        int span = 0;
        boolean containsLongLines = false;
        int asciiChars = 0;
        int nonAsciiChars = 0;
        while ((ch = in.read()) != -1) {
            if (ch == 10 || ch == 13) {
                span = 0;
                continue;
            }
            if (++span > 998) {
                containsLongLines = true;
            }
            if (!ASCIIUtil.isAscii(ch)) {
                ++nonAsciiChars;
                continue;
            }
            ++asciiChars;
        }
        if (nonAsciiChars == 0) {
            if (containsLongLines) {
                return "quoted-printable";
            }
            return "7bit";
        }
        if (nonAsciiChars > asciiChars) {
            return "base64";
        }
        return "quoted-printable";
    }

    public static String getTextTransferEncoding(String content) {
        int asciiChars = 0;
        int nonAsciiChars = 0;
        for (int i = 0; i < content.length(); ++i) {
            char ch = content.charAt(i);
            if (!ASCIIUtil.isAscii(ch)) {
                ++nonAsciiChars;
                continue;
            }
            ++asciiChars;
        }
        if (nonAsciiChars == 0) {
            return "7bit";
        }
        if (nonAsciiChars > asciiChars) {
            return "base64";
        }
        return "quoted-printable";
    }

    public static String getBinaryTransferEncoding(InputStream content) throws IOException {
        BufferedInputStream in = new BufferedInputStream(content, 4096);
        int previousChar = 0;
        int span = 0;
        int ch;
        while ((ch = in.read()) != -1) {
            if (ch == 10) {
                if (previousChar != 13) {
                    return "base64";
                }
                span = 0;
            } else {
                if (++span > 998) {
                    return "base64";
                }
                if (!ASCIIUtil.isAscii(ch)) {
                    return "base64";
                }
            }
            previousChar = ch;
        }
        return "7bit";
    }

    public static String fold(int used, String s) {
        char ch;
        int end;
        if (!SessionUtil.getBooleanProperty(MIME_FOLDTEXT, true)) {
            return s;
        }
        for (end = s.length() - 1; end >= 0 && ((ch = s.charAt(end)) == ' ' || ch == '\t'); --end) {
        }
        if (end != s.length() - 1) {
            s = s.substring(0, end + 1);
        }
        if (s.length() + used <= 76) {
            return s;
        }
        StringBuffer newString = new StringBuffer(s.length() + 8);
        while (used + s.length() > 76) {
            int breakPoint = -1;
            char breakChar = '\u0000';
            for (int i = 0; i < s.length() && (used + i <= 76 || breakPoint == -1); ++i) {
                char ch2 = s.charAt(i);
                if (ch2 == ' ' || ch2 == '\t') {
                    breakPoint = i++;
                    breakChar = ch2;
                    while (i < s.length() && ((ch2 = s.charAt(i)) == ' ' || ch2 == '\t')) {
                        ++i;
                    }
                    continue;
                }
                if (ch2 == '\n') {
                    newString.append('\\');
                    newString.append('\n');
                    continue;
                }
                if (ch2 != '\r') continue;
                newString.append('\\');
                newString.append('\n');
                if (++i >= s.length() || s.charAt(i) != '\n') continue;
                newString.append('\r');
            }
            if (breakPoint == -1) {
                newString.append(s);
                return newString.toString();
            }
            newString.append(s.substring(0, breakPoint));
            newString.append("\r\n");
            newString.append(breakChar);
            s = s.substring(breakPoint + 1);
            used = 1;
        }
        newString.append(s);
        return newString.toString();
    }

    public static String unfold(String s) {
        if (!SessionUtil.getBooleanProperty(MIME_FOLDTEXT, true)) {
            return s;
        }
        if (s.indexOf(10) < 0 && s.indexOf(13) < 0) {
            return s;
        }
        int length = s.length();
        StringBuffer newString = new StringBuffer(length);
        for (int i = 0; i < length; ++i) {
            char ch = s.charAt(i);
            if (ch == '\\') {
                if (i == length - 1) {
                    newString.append((int)ch);
                    continue;
                }
                char nextChar = s.charAt(i + 1);
                if (nextChar == '\n') {
                    newString.append('\n');
                    ++i;
                    continue;
                }
                if (nextChar == '\r') {
                    if (i == length - 2 || s.charAt(i + 2) != '\r') {
                        newString.append('\r');
                        ++i;
                        continue;
                    }
                    newString.append('\r');
                    newString.append('\n');
                    i += 2;
                    continue;
                }
                newString.append((int)ch);
                continue;
            }
            if (ch == '\n' || ch == '\r') {
                int scan;
                int lineBreak = i;
                boolean CRLF = false;
                if (ch == '\r' && i < length - 1 && s.charAt(i + 1) == '\n') {
                    ++i;
                    CRLF = true;
                }
                if ((scan = i + 1) < length && s.charAt(scan) == ' ') {
                    newString.append(' ');
                    for (i = scan + 1; i < length && s.charAt(i) == ' '; ++i) {
                    }
                    --i;
                    continue;
                }
                if (CRLF) {
                    newString.append("\r\n");
                    continue;
                }
                newString.append((int)ch);
                continue;
            }
            newString.append((int)ch);
        }
        return newString.toString();
    }
}

