/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jpa;

import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.sql.DataSource;
import org.springframework.beans.BeanUtils;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.instrument.classloading.LoadTimeWeaver;
import org.springframework.jdbc.datasource.lookup.DataSourceLookup;
import org.springframework.jdbc.datasource.lookup.JndiDataSourceLookup;
import org.springframework.jdbc.datasource.lookup.MapDataSourceLookup;
import org.springframework.orm.jpa.AbstractEntityManagerFactoryBean;
import org.springframework.orm.jpa.PersistenceUnitReader;
import org.springframework.orm.jpa.SpringPersistenceUnitInfo;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerEntityManagerFactoryBean
extends AbstractEntityManagerFactoryBean
implements ResourceLoaderAware {
    private static final String DEFAULT_PERSISTENCE_XML_LOCATION = "/META-INF/persistence.xml";
    private static Set<String> entityManagerFactoryNamesDeployed = new HashSet<String>();
    private String persistenceXmlLocation = "/META-INF/persistence.xml";
    private Resource persistenceUnitRootLocation;
    private boolean allowRedeploymentWithSameName = false;
    private LoadTimeWeaver loadTimeWeaver;
    private DataSource dataSource;
    private DataSourceLookup dataSourceLookup = new JndiDataSourceLookup();
    private ResourceLoader resourceLoader = new DefaultResourceLoader();
    private SpringPersistenceUnitInfo persistenceUnitInfo;

    public void setPersistenceXmlLocation(String persistenceXmlLocation) {
        this.persistenceXmlLocation = persistenceXmlLocation;
    }

    public void setPersistenceUnitRootLocation(Resource persistenceUnitRootPath) {
        this.persistenceUnitRootLocation = persistenceUnitRootPath;
    }

    public void setAllowRedeploymentWithSameName(boolean allowRedeploymentWithSameName) {
        this.allowRedeploymentWithSameName = allowRedeploymentWithSameName;
    }

    public void setLoadTimeWeaver(LoadTimeWeaver loadTimeWeaver) {
        this.loadTimeWeaver = loadTimeWeaver;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setDataSources(Map<String, DataSource> dataSources) {
        this.dataSourceLookup = new MapDataSourceLookup(dataSources);
    }

    public void setDataSourceLookup(DataSourceLookup dataSourceLookup) {
        this.dataSourceLookup = dataSourceLookup;
    }

    @Override
    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader != null ? resourceLoader : new DefaultResourceLoader();
    }

    @Override
    protected EntityManagerFactory createNativeEntityManagerFactory() throws PersistenceException {
        this.persistenceUnitInfo = this.parsePersistenceUnitInfo();
        String unitName = this.persistenceUnitInfo.getPersistenceUnitName();
        if (!this.allowRedeploymentWithSameName) {
            if (entityManagerFactoryNamesDeployed.contains(unitName)) {
                throw new IllegalStateException("EntityManagerFactory with name '" + unitName + "' " + "has already been deployed in this class loader; cannot deploy another");
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Allowing redeployment of EntityManagerFactory with name '" + unitName + "' "));
            }
        }
        entityManagerFactoryNamesDeployed.add(unitName);
        if (this.persistenceUnitInfo.getNonJtaDataSource() == null) {
            this.persistenceUnitInfo.setNonJtaDataSource(this.dataSource);
        }
        this.persistenceUnitInfo.setLoadTimeWeaver(this.loadTimeWeaver);
        this.persistenceUnitInfo.setPersistenceUnitRootUrl(this.findPersistenceUnitRootUrl());
        Class persistenceProviderClass = this.getPersistenceProviderClass();
        String puiProviderClassName = this.persistenceUnitInfo.getPersistenceProviderClassName();
        if (persistenceProviderClass == null && puiProviderClassName != null) {
            try {
                persistenceProviderClass = ClassUtils.forName(puiProviderClassName);
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalArgumentException("Cannot resolve provider class name '" + puiProviderClassName + "'", ex);
            }
        }
        if (persistenceProviderClass == null) {
            throw new IllegalStateException("Unable to determine persistence p rovider class. Please check configuration of " + this.getClass().getName() + "; " + "ideally specify the appropriate JpaVendorAdapter class for this provider");
        }
        PersistenceProvider pp = (PersistenceProvider)BeanUtils.instantiateClass(persistenceProviderClass);
        this.nativeEntityManagerFactory = pp.createContainerEntityManagerFactory((PersistenceUnitInfo)this.persistenceUnitInfo, this.getJpaPropertyMap());
        this.postProcessEntityManagerFactory(this.nativeEntityManagerFactory, this.persistenceUnitInfo);
        return this.nativeEntityManagerFactory;
    }

    private URL findPersistenceUnitRootUrl() {
        try {
            String rootPath = "";
            if (this.persistenceUnitRootLocation != null) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("Using explicit persistence unit root location: " + this.persistenceUnitRootLocation));
                }
                return this.persistenceUnitRootLocation.getURL();
            }
            Resource res = this.resourceLoader.getResource(rootPath);
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Defaulting persistence unit root location to class path root: " + res));
            }
            return res.getURL();
        }
        catch (IOException ex) {
            throw new PersistenceException("Unable to resolve persistence unit root URL", (Throwable)ex);
        }
    }

    private SpringPersistenceUnitInfo parsePersistenceUnitInfo() {
        PersistenceUnitReader reader = new PersistenceUnitReader(this.resourceLoader, this.dataSourceLookup);
        SpringPersistenceUnitInfo[] infos = reader.readPersistenceUnitInfos(this.persistenceXmlLocation);
        if (infos.length == 0) {
            throw new IllegalArgumentException("No persistence units parsed from [" + this.persistenceXmlLocation + "]");
        }
        SpringPersistenceUnitInfo pui = null;
        if (this.getPersistenceUnitName() == null) {
            pui = infos[0];
        } else {
            for (SpringPersistenceUnitInfo candidate : infos) {
                if (!this.getPersistenceUnitName().equals(candidate.getPersistenceUnitName())) continue;
                pui = candidate;
                break;
            }
        }
        if (pui == null) {
            throw new IllegalArgumentException("No persistence info with name matching '" + this.getPersistenceUnitName() + "' found");
        }
        return pui;
    }

    @Override
    public PersistenceUnitInfo getPersistenceUnitInfo() {
        return this.persistenceUnitInfo;
    }

    @Override
    public String getPersistenceUnitName() {
        if (this.persistenceUnitInfo != null) {
            return this.persistenceUnitInfo.getPersistenceUnitName();
        }
        return super.getPersistenceUnitName();
    }

    protected void postProcessEntityManagerFactory(EntityManagerFactory emf, PersistenceUnitInfo pui) {
    }
}

