/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jpa.support;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.orm.jpa.EntityManagerHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.web.portlet.handler.HandlerInterceptorAdapter;

public class PortletOpenEntityManagerInViewInterceptor
extends HandlerInterceptorAdapter {
    public static final String PARTICIPATE_SUFFIX = ".PARTICIPATE";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private EntityManagerFactory entityManagerFactory;

    public void setEntityManagerFactory(EntityManagerFactory emf) {
        this.entityManagerFactory = emf;
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.entityManagerFactory;
    }

    public boolean preHandle(PortletRequest request, PortletResponse response, Object handler) throws DataAccessException {
        if (TransactionSynchronizationManager.hasResource(this.getEntityManagerFactory())) {
            String participateAttributeName = this.getParticipateAttributeName();
            Integer count = (Integer)request.getAttribute(participateAttributeName);
            int newCount = count != null ? count + 1 : 1;
            request.setAttribute(this.getParticipateAttributeName(), (Object)new Integer(newCount));
        } else {
            this.logger.debug((Object)"Opening JPA persistence manager in OpenEntityManagerInViewInterceptor");
            try {
                EntityManager em = this.getEntityManagerFactory().createEntityManager();
                TransactionSynchronizationManager.bindResource(this.getEntityManagerFactory(), new EntityManagerHolder(em));
            }
            catch (PersistenceException ex) {
                throw new DataAccessResourceFailureException("Could not open JPA EntityManager", ex);
            }
        }
        return true;
    }

    public void afterCompletion(PortletRequest request, PortletResponse response, Object handler, Exception ex) throws DataAccessException {
        String participateAttributeName = this.getParticipateAttributeName();
        Integer count = (Integer)request.getAttribute(participateAttributeName);
        if (count != null) {
            if (count > 1) {
                request.setAttribute(participateAttributeName, (Object)new Integer(count - 1));
            } else {
                request.removeAttribute(participateAttributeName);
            }
        } else {
            EntityManagerHolder emHolder = (EntityManagerHolder)TransactionSynchronizationManager.unbindResource(this.getEntityManagerFactory());
            this.logger.debug((Object)"Closing JPA persistence manager in OpenEntityManagerInViewInterceptor");
            emHolder.getEntityManager().close();
        }
    }

    protected String getParticipateAttributeName() {
        return this.getEntityManagerFactory().toString() + PARTICIPATE_SUFFIX;
    }
}

