/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.interceptor;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.transaction.TransactionUsageException;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttributeEditor;
import org.springframework.transaction.interceptor.TransactionAttributeSource;
import org.springframework.util.ClassUtils;
import org.springframework.util.PatternMatchUtils;

public class MethodMapTransactionAttributeSource
implements TransactionAttributeSource,
BeanClassLoaderAware,
InitializingBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Map methodMap;
    private Map transactionAttributeMap = new HashMap();
    private Map methodNameMap = new HashMap();
    private ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();

    public void setMethodMap(Map methodMap) {
        this.methodMap = methodMap;
    }

    public void setBeanClassLoader(ClassLoader beanClassLoader) {
        this.beanClassLoader = beanClassLoader;
    }

    public void afterPropertiesSet() {
        this.initMethodMap();
    }

    protected synchronized void initMethodMap() {
        if (this.methodMap != null) {
            Iterator it = this.methodMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String name = (String)entry.getKey();
                TransactionAttribute attr = null;
                if (entry.getValue() instanceof TransactionAttribute) {
                    attr = (TransactionAttribute)entry.getValue();
                } else {
                    TransactionAttributeEditor editor = new TransactionAttributeEditor();
                    editor.setAsText(entry.getValue().toString());
                    attr = (TransactionAttribute)editor.getValue();
                }
                this.addTransactionalMethod(name, attr);
            }
        }
    }

    public void addTransactionalMethod(String name, TransactionAttribute attr) {
        int lastDotIndex = name.lastIndexOf(".");
        if (lastDotIndex == -1) {
            throw new TransactionUsageException("'" + name + "' is not a valid method name: format is FQN.methodName");
        }
        String className = name.substring(0, lastDotIndex);
        String methodName = name.substring(lastDotIndex + 1);
        try {
            Class clazz = ClassUtils.forName(className, this.beanClassLoader);
            this.addTransactionalMethod(clazz, methodName, attr);
        }
        catch (ClassNotFoundException ex) {
            throw new TransactionUsageException("Class '" + className + "' not found");
        }
    }

    public void addTransactionalMethod(Class clazz, String mappedName, TransactionAttribute attr) {
        String name = clazz.getName() + '.' + mappedName;
        Method[] methods = clazz.getDeclaredMethods();
        ArrayList<Method> matchingMethods = new ArrayList<Method>();
        for (int i = 0; i < methods.length; ++i) {
            if (!this.isMatch(methods[i].getName(), mappedName)) continue;
            matchingMethods.add(methods[i]);
        }
        if (matchingMethods.isEmpty()) {
            throw new TransactionUsageException("Couldn't find method '" + mappedName + "' on class [" + clazz.getName() + "]");
        }
        Iterator it = matchingMethods.iterator();
        while (it.hasNext()) {
            Method method = (Method)it.next();
            String regMethodName = (String)this.methodNameMap.get(method);
            if (regMethodName == null || !regMethodName.equals(name) && regMethodName.length() <= name.length()) {
                if (this.logger.isDebugEnabled() && regMethodName != null) {
                    this.logger.debug((Object)("Replacing attribute for transactional method [" + method + "]: current name '" + name + "' is more specific than '" + regMethodName + "'"));
                }
                this.methodNameMap.put(method, name);
                this.addTransactionalMethod(method, attr);
                continue;
            }
            if (!this.logger.isDebugEnabled() || regMethodName == null) continue;
            this.logger.debug((Object)("Keeping attribute for transactional method [" + method + "]: current name '" + name + "' is not more specific than '" + regMethodName + "'"));
        }
    }

    public void addTransactionalMethod(Method method, TransactionAttribute attr) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Adding transactional method [" + method + "] with attribute [" + attr + "]"));
        }
        this.transactionAttributeMap.put(method, attr);
    }

    protected boolean isMatch(String methodName, String mappedName) {
        return PatternMatchUtils.simpleMatch(mappedName, methodName);
    }

    public TransactionAttribute getTransactionAttribute(Method method, Class targetClass) {
        if (this.methodMap != null) {
            this.initMethodMap();
        }
        return (TransactionAttribute)this.transactionAttributeMap.get(method);
    }
}

