/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.portlet.mvc;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.web.portlet.ModelAndView;
import org.springframework.web.portlet.mvc.AbstractFormController;
import org.springframework.web.portlet.util.PortletUtils;
import org.springframework.web.util.WebUtils;

public abstract class AbstractWizardFormController
extends AbstractFormController {
    public static final String PARAM_FINISH = "_finish";
    public static final String PARAM_CANCEL = "_cancel";
    public static final String PARAM_TARGET = "_target";
    public static final String PARAM_PAGE = "_page";
    private String[] pages;
    private String pageAttribute;
    private boolean allowDirtyBack = true;
    private boolean allowDirtyForward = false;

    public AbstractWizardFormController() {
        this.setSessionForm(true);
        this.setValidateOnBinding(false);
    }

    public final void setPages(String[] pages) {
        if (pages == null || pages.length == 0) {
            throw new IllegalArgumentException("No wizard pages defined");
        }
        this.pages = pages;
    }

    public final String[] getPages() {
        return this.pages;
    }

    protected final int getPageCount() {
        return this.pages.length;
    }

    public final void setPageAttribute(String pageAttribute) {
        this.pageAttribute = pageAttribute;
    }

    public final String getPageAttribute() {
        return this.pageAttribute;
    }

    public final void setAllowDirtyBack(boolean allowDirtyBack) {
        this.allowDirtyBack = allowDirtyBack;
    }

    public final boolean isAllowDirtyBack() {
        return this.allowDirtyBack;
    }

    public final void setAllowDirtyForward(boolean allowDirtyForward) {
        this.allowDirtyForward = allowDirtyForward;
    }

    public final boolean isAllowDirtyForward() {
        return this.allowDirtyForward;
    }

    protected final void onBindAndValidate(PortletRequest request, Object command, BindException errors) throws Exception {
        this.onBindAndValidate(request, command, errors, this.getCurrentPage(request));
    }

    protected void onBindAndValidate(PortletRequest request, Object command, BindException errors, int page) throws Exception {
    }

    protected boolean isFormSubmission(PortletRequest request) {
        return super.isFormSubmission(request) || this.isFinishRequest(request) || this.isCancelRequest(request);
    }

    protected final Map referenceData(PortletRequest request, Object command, Errors errors) throws Exception {
        return this.referenceData(request, command, errors, this.getCurrentPage(request));
    }

    protected Map referenceData(PortletRequest request, Object command, Errors errors, int page) throws Exception {
        return this.referenceData(request, page);
    }

    protected Map referenceData(PortletRequest request, int page) throws Exception {
        return null;
    }

    protected final ModelAndView showForm(RenderRequest request, RenderResponse response, BindException errors) throws Exception {
        return this.showPage(request, errors, this.getInitialPage((PortletRequest)request, errors.getTarget()));
    }

    protected final ModelAndView showPage(RenderRequest request, BindException errors, int page) throws Exception {
        if (page >= 0 && page < this.getPageCount((PortletRequest)request, errors.getTarget())) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Showing wizard page " + page + " for form bean '" + this.getCommandName() + "'"));
            }
            Integer pageInteger = new Integer(page);
            String pageAttrName = this.getPageSessionAttributeName((PortletRequest)request);
            if (this.isSessionForm()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Setting page session attribute [" + pageAttrName + "] to: " + pageInteger));
                }
                request.getPortletSession().setAttribute(pageAttrName, (Object)pageInteger);
            }
            request.setAttribute(pageAttrName, (Object)pageInteger);
            HashMap<String, Integer> controlModel = new HashMap<String, Integer>();
            if (this.pageAttribute != null) {
                controlModel.put(this.pageAttribute, new Integer(page));
            }
            String viewName = this.getViewName((PortletRequest)request, errors.getTarget(), page);
            return this.showForm(request, errors, viewName, controlModel);
        }
        throw new PortletException("Invalid wizard page number: " + page);
    }

    protected int getPageCount(PortletRequest request, Object command) {
        return this.getPageCount();
    }

    protected String getViewName(PortletRequest request, Object command, int page) {
        return this.getPages()[page];
    }

    protected int getInitialPage(PortletRequest request, Object command) {
        return this.getInitialPage(request);
    }

    protected int getInitialPage(PortletRequest request) {
        return 0;
    }

    protected String getPageSessionAttributeName(PortletRequest request) {
        return this.getPageSessionAttributeName();
    }

    protected String getPageSessionAttributeName() {
        return this.getClass().getName() + ".PAGE." + this.getCommandName();
    }

    protected void setPageRenderParameter(ActionResponse response, int page) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Setting page number render parameter [_page] to [" + page + "]"));
        }
        try {
            response.setRenderParameter(PARAM_PAGE, new Integer(page).toString());
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    protected void setTargetRenderParameter(ActionRequest request, ActionResponse response) {
        try {
            Iterator it = PortletUtils.getParametersStartingWith((PortletRequest)request, PARAM_TARGET).entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String param = PARAM_TARGET + (String)entry.getKey();
                Object value = entry.getValue();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Setting target render parameter [" + param + "]"));
                }
                if (value instanceof String) {
                    response.setRenderParameter(param, (String)value);
                }
                if (!(value instanceof String[])) continue;
                response.setRenderParameter(param, (String[])value);
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    protected void setFinishRenderParameter(ActionRequest request, ActionResponse response) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Setting cancel render parameter [_finish]");
        }
        try {
            String name = PortletUtils.getSubmitParameter((PortletRequest)request, PARAM_FINISH);
            if (name != null) {
                response.setRenderParameter(name, request.getParameter(name));
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    protected void setCancelRenderParameter(ActionRequest request, ActionResponse response) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Setting cancel render parameter [_cancel]");
        }
        try {
            String name = PortletUtils.getSubmitParameter((PortletRequest)request, PARAM_CANCEL);
            if (name != null) {
                response.setRenderParameter(name, request.getParameter(name));
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    protected ModelAndView renderInvalidSubmit(RenderRequest request, RenderResponse response) throws Exception {
        return this.showNewForm(request, response);
    }

    protected void handleInvalidSubmit(ActionRequest request, ActionResponse response) throws Exception {
    }

    protected final ModelAndView renderFormSubmission(RenderRequest request, RenderResponse response, Object command, BindException errors) throws Exception {
        int currentPage = this.getCurrentPage((PortletRequest)request);
        String pageAttrName = this.getPageSessionAttributeName((PortletRequest)request);
        request.setAttribute(pageAttrName, (Object)new Integer(currentPage));
        if (this.isCancelRequest((PortletRequest)request)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Cancelling wizard for form bean '" + this.getCommandName() + "'"));
            }
            return this.renderCancel(request, response, command, errors);
        }
        if (this.isFinishRequest((PortletRequest)request)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Finishing wizard for form bean '" + this.getCommandName() + "'"));
            }
            return this.renderValidatePagesAndFinish(request, response, command, errors, currentPage);
        }
        int targetPage = this.getTargetPage((PortletRequest)request, command, errors, currentPage);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Target page " + targetPage + " requested"));
        }
        if (targetPage != currentPage && (!errors.hasErrors() || this.allowDirtyBack && targetPage < currentPage || this.allowDirtyForward && targetPage > currentPage)) {
            return this.showPage(request, errors, targetPage);
        }
        return this.showPage(request, errors, currentPage);
    }

    protected final void processFormSubmission(ActionRequest request, ActionResponse response, Object command, BindException errors) throws Exception {
        int currentPage = this.getCurrentPage((PortletRequest)request);
        String pageAttrName = this.getPageSessionAttributeName((PortletRequest)request);
        if (this.isSessionForm()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Removing page session attribute [" + pageAttrName + "]"));
            }
            request.getPortletSession().removeAttribute(pageAttrName);
        }
        request.setAttribute(pageAttrName, (Object)new Integer(currentPage));
        if (this.isCancelRequest((PortletRequest)request)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Cancelling wizard for form bean '" + this.getCommandName() + "'"));
            }
            this.setPageRenderParameter(response, currentPage);
            this.setCancelRenderParameter(request, response);
            this.processCancel(request, response, command, errors);
            return;
        }
        if (this.isFinishRequest((PortletRequest)request)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Finishing wizard for form bean '" + this.getCommandName() + "'"));
            }
            if (!this.isRedirectAction()) {
                this.setPageRenderParameter(response, currentPage);
                this.setFinishRenderParameter(request, response);
            }
            this.validatePagesAndFinish(request, response, command, errors, currentPage);
            return;
        }
        if (!this.suppressValidation((PortletRequest)request)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Validating wizard page " + currentPage + " for form bean '" + this.getCommandName() + "'"));
            }
            this.validatePage(command, errors, currentPage, false);
        }
        this.setPageRenderParameter(response, currentPage);
        this.setTargetRenderParameter(request, response);
        this.passRenderParameters(request, response);
        this.postProcessPage(request, command, errors, currentPage);
    }

    protected int getCurrentPage(PortletRequest request) {
        String pageAttrName = this.getPageSessionAttributeName(request);
        Integer pageAttr = (Integer)request.getAttribute(pageAttrName);
        if (pageAttr != null) {
            return pageAttr;
        }
        String pageParam = request.getParameter(PARAM_PAGE);
        if (pageParam != null) {
            return Integer.parseInt(pageParam);
        }
        if (this.isSessionForm() && (pageAttr = (Integer)request.getPortletSession().getAttribute(pageAttrName)) != null) {
            return pageAttr;
        }
        throw new IllegalStateException("Page attribute [" + pageAttrName + "] neither found in session nor in request");
    }

    protected boolean isFinishRequest(PortletRequest request) {
        return PortletUtils.hasSubmitParameter(request, PARAM_FINISH);
    }

    protected boolean isCancelRequest(PortletRequest request) {
        return PortletUtils.hasSubmitParameter(request, PARAM_CANCEL);
    }

    protected int getTargetPage(PortletRequest request, Object command, Errors errors, int currentPage) {
        return this.getTargetPage(request, currentPage);
    }

    protected int getTargetPage(PortletRequest request, int currentPage) {
        Enumeration paramNames = request.getParameterNames();
        while (paramNames.hasMoreElements()) {
            String paramName = (String)paramNames.nextElement();
            if (!paramName.startsWith(PARAM_TARGET)) continue;
            for (int i = 0; i < WebUtils.SUBMIT_IMAGE_SUFFIXES.length; ++i) {
                String suffix = WebUtils.SUBMIT_IMAGE_SUFFIXES[i];
                if (!paramName.endsWith(suffix)) continue;
                paramName = paramName.substring(0, paramName.length() - suffix.length());
            }
            return Integer.parseInt(paramName.substring(PARAM_TARGET.length()));
        }
        return currentPage;
    }

    private ModelAndView renderValidatePagesAndFinish(RenderRequest request, RenderResponse response, Object command, BindException errors, int currentPage) throws Exception {
        if (errors.hasErrors()) {
            return this.showPage(request, errors, currentPage);
        }
        return this.renderFinish(request, response, command, errors);
    }

    private void validatePagesAndFinish(ActionRequest request, ActionResponse response, Object command, BindException errors, int currentPage) throws Exception {
        if (errors.hasErrors()) {
            this.setPageRenderParameter(response, currentPage);
            this.passRenderParameters(request, response);
            return;
        }
        if (!this.suppressValidation((PortletRequest)request)) {
            for (int page = 0; page < this.getPageCount((PortletRequest)request, command); ++page) {
                this.validatePage(command, errors, page, true);
                if (!errors.hasErrors()) continue;
                this.setPageRenderParameter(response, currentPage);
                this.passRenderParameters(request, response);
                return;
            }
        }
        if (!this.isRedirectAction()) {
            this.setPageRenderParameter(response, currentPage);
        }
        this.processFinish(request, response, command, errors);
    }

    protected void validatePage(Object command, Errors errors, int page, boolean finish) {
        this.validatePage(command, errors, page);
    }

    protected void validatePage(Object command, Errors errors, int page) {
    }

    protected void postProcessPage(ActionRequest request, Object command, Errors errors, int page) throws Exception {
    }

    protected ModelAndView renderFinish(RenderRequest request, RenderResponse response, Object command, BindException errors) throws Exception {
        throw new PortletException("Wizard form controller class [" + this.getClass().getName() + "] does not support a finish render request");
    }

    protected void processFinish(ActionRequest request, ActionResponse response, Object command, BindException errors) throws Exception {
        throw new PortletException("Wizard form controller class [" + this.getClass().getName() + "] does not support a finish action request");
    }

    protected ModelAndView renderCancel(RenderRequest request, RenderResponse response, Object command, BindException errors) throws Exception {
        throw new PortletException("Wizard form controller class [" + this.getClass().getName() + "] does not support a cancel render request");
    }

    protected void processCancel(ActionRequest request, ActionResponse response, Object command, BindException errors) throws Exception {
        throw new PortletException("Wizard form controller class [" + this.getClass().getName() + "] does not support a cancel action request");
    }
}

