/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector;

import java.io.Serializable;
import java.lang.reflect.Method;
import javax.management.ObjectName;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.KernelRegistry;
import org.apache.geronimo.kernel.proxy.DeadProxyException;

public class ConnectorMethodInterceptor
implements MethodInterceptor,
Serializable {
    private final String kernelName;
    private final ObjectName targetName;
    private transient Object internalProxy;

    public ConnectorMethodInterceptor(String kernelName, ObjectName targetName) {
        this.kernelName = kernelName;
        this.targetName = targetName;
    }

    public Object intercept(Object o, Method method, Object[] objects, MethodProxy methodProxy) throws Throwable {
        if (this.internalProxy == null) {
            this.connectInternalProxy();
        }
        try {
            return methodProxy.invoke(this.internalProxy, objects);
        }
        catch (DeadProxyException e) {
            this.connectInternalProxy();
            return methodProxy.invoke(this.internalProxy, objects);
        }
    }

    public void setInternalProxy(Object internalProxy) {
        this.internalProxy = internalProxy;
    }

    private void connectInternalProxy() throws Throwable {
        Kernel kernel = KernelRegistry.getKernel((String)this.kernelName);
        try {
            this.internalProxy = kernel.invoke(this.targetName, "$getConnectionFactory");
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not connect proxy to ManagedConnectionFactoryWrapper").initCause(e);
        }
    }
}

