/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector.outbound.connectiontracking;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.resource.ResourceException;
import org.apache.geronimo.connector.outbound.ConnectionInfo;
import org.apache.geronimo.connector.outbound.ConnectionTrackingInterceptor;
import org.apache.geronimo.connector.outbound.ManagedConnectionInfo;
import org.apache.geronimo.connector.outbound.connectiontracking.ConnectionTracker;
import org.apache.geronimo.transaction.InstanceContext;
import org.apache.geronimo.transaction.TrackedConnectionAssociator;

public class ConnectionTrackingCoordinator
implements TrackedConnectionAssociator,
ConnectionTracker {
    private final ThreadLocal currentInstanceContexts = new ThreadLocal();

    public InstanceContext enter(InstanceContext newInstanceContext) throws ResourceException {
        InstanceContext oldInstanceContext = (InstanceContext)this.currentInstanceContexts.get();
        this.currentInstanceContexts.set(newInstanceContext);
        this.notifyConnections(newInstanceContext);
        return oldInstanceContext;
    }

    private void notifyConnections(InstanceContext oldInstanceContext) throws ResourceException {
        Map connectionManagerToManagedConnectionInfoMap = oldInstanceContext.getConnectionManagerMap();
        Iterator i = connectionManagerToManagedConnectionInfoMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            ConnectionTrackingInterceptor mcci = (ConnectionTrackingInterceptor)entry.getKey();
            Set connections = (Set)entry.getValue();
            mcci.enter(connections);
        }
    }

    public void newTransaction() throws ResourceException {
        InstanceContext oldInstanceContext = (InstanceContext)this.currentInstanceContexts.get();
        this.notifyConnections(oldInstanceContext);
    }

    public void exit(InstanceContext reenteringInstanceContext) throws ResourceException {
        InstanceContext oldInstanceContext = (InstanceContext)this.currentInstanceContexts.get();
        Map resources = oldInstanceContext.getConnectionManagerMap();
        Iterator i = resources.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            ConnectionTrackingInterceptor mcci = (ConnectionTrackingInterceptor)entry.getKey();
            Set connections = (Set)entry.getValue();
            mcci.exit(connections);
            if (!connections.isEmpty()) continue;
            i.remove();
        }
        this.currentInstanceContexts.set(reenteringInstanceContext);
    }

    public void handleObtained(ConnectionTrackingInterceptor connectionTrackingInterceptor, ConnectionInfo connectionInfo) {
        InstanceContext instanceContext = (InstanceContext)this.currentInstanceContexts.get();
        if (instanceContext == null) {
            return;
        }
        Map resources = instanceContext.getConnectionManagerMap();
        HashSet<ConnectionInfo> infos = (HashSet<ConnectionInfo>)resources.get(connectionTrackingInterceptor);
        if (infos == null) {
            infos = new HashSet<ConnectionInfo>();
            resources.put(connectionTrackingInterceptor, infos);
        }
        infos.add(connectionInfo);
    }

    public void handleReleased(ConnectionTrackingInterceptor connectionTrackingInterceptor, ConnectionInfo connectionInfo) {
        InstanceContext instanceContext = (InstanceContext)this.currentInstanceContexts.get();
        if (instanceContext == null) {
            return;
        }
        Map resources = instanceContext.getConnectionManagerMap();
        Set infos = (Set)resources.get(connectionTrackingInterceptor);
        if (connectionInfo.getConnectionHandle() == null) {
            ManagedConnectionInfo mci = connectionInfo.getManagedConnectionInfo();
            Collection toRemove = mci.getConnectionInfos();
            infos.removeAll(toRemove);
        } else {
            infos.remove(connectionInfo);
        }
    }

    public void setEnvironment(ConnectionInfo connectionInfo, String key) {
        InstanceContext currentInstanceContext = (InstanceContext)this.currentInstanceContexts.get();
        if (currentInstanceContext != null) {
            Set unshareableResources = currentInstanceContext.getUnshareableResources();
            boolean unshareable = unshareableResources.contains(key);
            connectionInfo.setUnshareable(unshareable);
            Set applicationManagedSecurityResources = currentInstanceContext.getApplicationManagedSecurityResources();
            boolean applicationManagedSecurity = applicationManagedSecurityResources.contains(key);
            connectionInfo.setApplicationManagedSecurity(applicationManagedSecurity);
        }
    }
}

