/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.components.drools.dsl;

import javax.jbi.messaging.MessagingException;
import javax.xml.namespace.QName;
import org.apache.servicemix.components.drools.JbiHelper;
import org.apache.servicemix.components.drools.dsl.JbiConsequence;
import org.drools.rule.Rule;
import org.drools.smf.Configuration;
import org.drools.smf.ConsequenceFactory;
import org.drools.smf.FactoryException;
import org.drools.spi.Consequence;
import org.drools.spi.RuleBaseContext;
import org.drools.spi.Tuple;

public class InvokeConsequenceFactory
implements ConsequenceFactory {
    public Consequence newConsequence(Rule rule, RuleBaseContext ruleBaseContext, Configuration configuration) throws FactoryException {
        final QName operation = this.toQName(configuration, configuration.getAttribute("operation"));
        final QName service = this.toQName(configuration, configuration.getAttribute("service"));
        final QName interfaceName = this.toQName(configuration, configuration.getAttribute("interface"));
        return new JbiConsequence(){

            protected void invokeJbiOperation(JbiHelper helper, Tuple tuple) throws MessagingException {
                helper.invoke(service, operation, interfaceName);
            }
        };
    }

    protected QName toQName(Configuration configuration, String text) {
        if (text == null) {
            return null;
        }
        String[] names = configuration.getAttributeNames();
        String localPart = text;
        String prefix = null;
        int idx = text.indexOf(58);
        if (idx >= 0) {
            prefix = "xmlns:" + text.substring(0, idx);
            localPart = text.substring(idx + 1);
        }
        String uri = "";
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            if (prefix == null) {
                if (!"xmlns".equals(name)) continue;
                uri = configuration.getAttribute(name);
                break;
            }
            if (!name.equals(prefix)) continue;
            uri = configuration.getAttribute(name);
            break;
        }
        System.out.println("Creating QName with uri: " + uri + " name: " + localPart);
        return new QName(uri, localPart);
    }
}

