/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.components.email;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.mail.Address;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import org.apache.servicemix.components.util.MarshalerSupport;
import org.apache.servicemix.expression.Expression;
import org.apache.servicemix.expression.PropertyExpression;

public abstract class MailMarshalerSupport
extends MarshalerSupport {
    private DateFormat dateFormat = DateFormat.getInstance();
    private Expression to = new PropertyExpression("org.apache.servicemix.email.to");
    private Expression cc = new PropertyExpression("org.apache.servicemix.email.cc");
    private Expression bcc = new PropertyExpression("org.apache.servicemix.email.bcc");
    private Expression from = new PropertyExpression("org.apache.servicemix.email.from", (Object)"noone@servicemix.org");
    private Expression text = new PropertyExpression("org.apache.servicemix.email.text");
    private Expression html = new PropertyExpression("org.apache.servicemix.email.html");
    private Expression subject = new PropertyExpression("org.apache.servicemix.email.subject", (Object)"Message from ServiceMix");
    private Expression replyTo = new PropertyExpression("org.apache.servicemix.email.replyTo");
    private Expression sentDate = new PropertyExpression("org.apache.servicemix.email.sentDate");
    private Expression attachments = new PropertyExpression("org.apache.servicemix.email.attachments");

    public Expression getTo() {
        return this.to;
    }

    public void setTo(Expression to) {
        this.to = to;
    }

    public Expression getCc() {
        return this.cc;
    }

    public void setCc(Expression cc) {
        this.cc = cc;
    }

    public Expression getBcc() {
        return this.bcc;
    }

    public void setBcc(Expression bcc) {
        this.bcc = bcc;
    }

    public Expression getFrom() {
        return this.from;
    }

    public void setFrom(Expression from) {
        this.from = from;
    }

    public Expression getText() {
        return this.text;
    }

    public void setText(Expression text) {
        this.text = text;
    }

    public Expression getHtml() {
        return this.html;
    }

    public void setHtml(Expression html) {
        this.html = html;
    }

    public Expression getSubject() {
        return this.subject;
    }

    public void setSubject(Expression subject) {
        this.subject = subject;
    }

    public Expression getReplyTo() {
        return this.replyTo;
    }

    public void setReplyTo(Expression replyTo) {
        this.replyTo = replyTo;
    }

    public Expression getSentDate() {
        return this.sentDate;
    }

    public void setSentDate(Expression sentDate) {
        this.sentDate = sentDate;
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    public Expression getAttachments() {
        return this.attachments;
    }

    public void setAttachments(Expression attachments) {
        this.attachments = attachments;
    }

    protected Date getSentDate(MessageExchange exchange, NormalizedMessage normalizedMessage) throws MessagingException {
        return this.asDate(this.sentDate.evaluate(exchange, normalizedMessage));
    }

    protected String getSubject(MessageExchange exchange, NormalizedMessage normalizedMessage) throws MessagingException {
        return this.asString(this.subject.evaluate(exchange, normalizedMessage));
    }

    protected String getText(MessageExchange exchange, NormalizedMessage normalizedMessage) throws MessagingException, TransformerException {
        Source content;
        String text = this.asString(this.text.evaluate(exchange, normalizedMessage));
        if (text == null && (content = normalizedMessage.getContent()) != null) {
            text = this.getTransformer().toString(content);
        }
        return text;
    }

    protected String getHtml(MessageExchange exchange, NormalizedMessage normalizedMessage) throws MessagingException, TransformerException {
        return this.html != null ? this.asString(this.html.evaluate(exchange, normalizedMessage)) : null;
    }

    protected Address asAddress(Object value) throws AddressException {
        if (value instanceof Address) {
            return (Address)value;
        }
        if (value instanceof String) {
            return new InternetAddress((String)value);
        }
        if (value != null) {
            throw new IllegalArgumentException("Expression does not evaluate to an Address. Is of type: " + value.getClass().getName() + " with value: " + value);
        }
        return null;
    }

    protected Date asDate(Object value) {
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof String) {
            String text = (String)value;
            try {
                return this.dateFormat.parse(text);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Invalid date format for: " + text + ". Reason: " + e);
            }
        }
        if (value != null) {
            throw new IllegalArgumentException("Expression does not evaluate to a Date. Is of type: " + value.getClass().getName() + " with value: " + value);
        }
        return null;
    }

    protected Address[] asAddressArray(Object value) throws AddressException {
        if (value instanceof Address[]) {
            return (Address[])value;
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            Address[] answer = new Address[collection.size()];
            int i = 0;
            Iterator iter = collection.iterator();
            while (iter.hasNext()) {
                answer[i++] = this.asAddress(iter.next());
            }
            return answer;
        }
        if (value != null) {
            throw new IllegalArgumentException("Expression does not evaluate to an Address[]. Is of type: " + value.getClass().getName() + " with value: " + value);
        }
        return null;
    }

    protected Object asStringOrStringArray(Object value) {
        if (value instanceof String) {
            return value;
        }
        if (value instanceof String[]) {
            return value;
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            String[] answer = new String[collection.size()];
            int i = 0;
            Iterator iter = collection.iterator();
            while (iter.hasNext()) {
                answer[i++] = this.asString(iter.next());
            }
            return answer;
        }
        if (value != null) {
            throw new IllegalArgumentException("Expression does not evaluate to a String[]. Is of type: " + value.getClass().getName() + " with value: " + value);
        }
        return null;
    }
}

