/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.components.file;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.jbi.JBIException;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.components.util.DefaultFileMarshaler;
import org.apache.servicemix.components.util.FileMarshaler;
import org.apache.servicemix.components.util.OutBinding;

public class FileWriter
extends OutBinding {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$servicemix$components$file$FileWriter == null ? (class$org$apache$servicemix$components$file$FileWriter = FileWriter.class$("org.apache.servicemix.components.file.FileWriter")) : class$org$apache$servicemix$components$file$FileWriter));
    private File directory;
    private FileMarshaler marshaler = new DefaultFileMarshaler();
    private String tempFilePrefix = "servicemix-";
    private String tempFileSuffix = ".xml";
    private boolean autoCreateDirectory = true;
    static /* synthetic */ Class class$org$apache$servicemix$components$file$FileWriter;

    public File getDirectory() {
        return this.directory;
    }

    public void setDirectory(File directory) {
        this.directory = directory;
    }

    public FileMarshaler getMarshaler() {
        return this.marshaler;
    }

    public void setMarshaler(FileMarshaler marshaler) {
        this.marshaler = marshaler;
    }

    public String getTempFilePrefix() {
        return this.tempFilePrefix;
    }

    public void setTempFilePrefix(String tempFilePrefix) {
        this.tempFilePrefix = tempFilePrefix;
    }

    public String getTempFileSuffix() {
        return this.tempFileSuffix;
    }

    public void setTempFileSuffix(String tempFileSuffix) {
        this.tempFileSuffix = tempFileSuffix;
    }

    public boolean isAutoCreateDirectory() {
        return this.autoCreateDirectory;
    }

    public void setAutoCreateDirectory(boolean autoCreateDirectory) {
        this.autoCreateDirectory = autoCreateDirectory;
    }

    protected void init() throws JBIException {
        if (this.directory == null) {
            throw new IllegalArgumentException("You must specify the directory property");
        }
        if (this.isAutoCreateDirectory()) {
            this.directory.mkdirs();
        }
        if (!this.directory.isDirectory()) {
            throw new IllegalArgumentException("The directory property must be a directory but was: " + this.directory);
        }
        super.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(MessageExchange exchange, NormalizedMessage message) throws Exception {
        OutputStream out = null;
        try {
            String name = this.marshaler.getOutputName(exchange, message);
            File newFile = null;
            newFile = name == null ? File.createTempFile(this.tempFilePrefix, this.tempFileSuffix, this.directory) : new File(this.directory, name);
            out = new BufferedOutputStream(new FileOutputStream(newFile));
            this.marshaler.writeMessage(exchange, message, out, name);
            this.done(exchange);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    log.error((Object)("Caught exception while closing stream on error: " + e), (Throwable)e);
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

