/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.components.http;

import java.io.IOException;
import java.net.URL;
import javax.jbi.JBIException;
import javax.jbi.component.ComponentContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.components.http.HttpInOutBinding;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.security.SslSocketConnector;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.jetty.servlet.ServletMapping;
import org.mortbay.thread.BoundedThreadPool;
import org.mortbay.thread.ThreadPool;
import org.springframework.core.io.ClassPathResource;

public class HttpsConnector
extends HttpInOutBinding {
    private SslSocketConnector listener = new SslSocketConnector();
    private int maxThreads = 256;
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$servicemix$components$http$HttpsConnector == null ? (class$org$apache$servicemix$components$http$HttpsConnector = HttpsConnector.class$("org.apache.servicemix.components.http.HttpsConnector")) : class$org$apache$servicemix$components$http$HttpsConnector));
    private Server server;
    private String host;
    private int port;
    private String keyPassword;
    private String keyStore;
    private String keyStorePassword;
    private String keyStoreType = "JKS";
    private String protocol = "TLS";
    private String algorithm = "SunX509";
    private boolean wantClientAuth = false;
    private boolean needClientAuth = false;
    static /* synthetic */ Class class$org$apache$servicemix$components$http$HttpsConnector;
    static /* synthetic */ Class class$org$apache$servicemix$components$http$BindingServlet;

    public HttpsConnector(String host, int port, String keyPassword, String keyStorePassword, String keyStore, boolean needClientAuth, boolean wantClientAuth) {
        this.host = host;
        this.port = port;
        this.keyPassword = keyPassword;
        this.keyStorePassword = keyStorePassword;
        this.keyStore = keyStore;
        this.wantClientAuth = wantClientAuth;
        this.needClientAuth = needClientAuth;
    }

    public HttpsConnector() {
    }

    public HttpsConnector(SslSocketConnector listener) {
        this.listener = listener;
    }

    public void init(ComponentContext cc) throws JBIException {
        super.init(cc);
        if (this.keyStore == null) {
            this.keyStore = System.getProperty("javax.net.ssl.keyStore", "");
            if (this.keyStore == null) {
                throw new IllegalArgumentException("keyStore or system property javax.net.ssl.keyStore must be set");
            }
        }
        if (this.keyStore.startsWith("classpath:")) {
            try {
                String res = this.keyStore.substring(10);
                URL url = new ClassPathResource(res).getURL();
                this.keyStore = url.toString();
            }
            catch (IOException e) {
                throw new JBIException("Unable to find keystore " + this.keyStore, (Throwable)e);
            }
        }
        if (this.keyStorePassword == null) {
            this.keyStorePassword = System.getProperty("javax.net.ssl.keyStorePassword");
            if (this.keyStorePassword == null) {
                throw new IllegalArgumentException("keyStorePassword or system property javax.net.ssl.keyStorePassword must be set");
            }
        }
        if (this.listener == null) {
            this.listener = new SslSocketConnector();
        }
        this.listener.setHost(this.host);
        this.listener.setPort(this.port);
        this.listener.setConfidentialPort(this.port);
        this.listener.setPassword(this.keyStorePassword);
        this.listener.setKeyPassword(this.keyPassword != null ? this.keyPassword : this.keyStorePassword);
        this.listener.setKeystore(this.keyStore);
        this.listener.setWantClientAuth(this.wantClientAuth);
        this.listener.setNeedClientAuth(this.needClientAuth);
        this.listener.setProtocol(this.protocol);
        this.listener.setAlgorithm(this.algorithm);
        this.listener.setKeystoreType(this.keyStoreType);
        this.server = new Server();
        BoundedThreadPool btp = new BoundedThreadPool();
        btp.setMaxThreads(this.getMaxThreads());
        this.server.setThreadPool((ThreadPool)btp);
    }

    public void start() throws JBIException {
        this.server.setConnectors(new Connector[]{this.listener});
        ContextHandler context = new ContextHandler();
        context.setContextPath("/");
        ServletHolder holder = new ServletHolder();
        holder.setName("jbiServlet");
        holder.setClassName((class$org$apache$servicemix$components$http$BindingServlet == null ? (class$org$apache$servicemix$components$http$BindingServlet = HttpsConnector.class$("org.apache.servicemix.components.http.BindingServlet")) : class$org$apache$servicemix$components$http$BindingServlet).getName());
        ServletHandler handler = new ServletHandler();
        handler.setServlets(new ServletHolder[]{holder});
        ServletMapping mapping = new ServletMapping();
        mapping.setServletName("jbiServlet");
        mapping.setPathSpec("/*");
        handler.setServletMappings(new ServletMapping[]{mapping});
        context.setHandler((Handler)handler);
        this.server.setHandler((Handler)context);
        context.setAttribute("binding", (Object)this);
        try {
            this.server.start();
        }
        catch (Exception e) {
            log.warn((Object)e.toString());
            throw new JBIException("Start failed: " + e, (Throwable)e);
        }
    }

    public void stop() throws JBIException {
        try {
            if (this.server != null) {
                this.server.stop();
            }
        }
        catch (Exception e) {
            log.warn((Object)e.toString());
            throw new JBIException("Stop failed: " + e, (Throwable)e);
        }
    }

    public void shutDown() throws JBIException {
        this.server = null;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public Server getServer() {
        return this.server;
    }

    public void setServer(Server server) {
        this.server = server;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    public void setKeyPassword(String keyPassword) {
        this.keyPassword = keyPassword;
    }

    public String getKeyStore() {
        return this.keyStore;
    }

    public void setKeyStore(String keyStore) {
        this.keyStore = keyStore;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    public boolean isNeedClientAuth() {
        return this.needClientAuth;
    }

    public void setNeedClientAuth(boolean needClientAuth) {
        this.needClientAuth = needClientAuth;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public boolean isWantClientAuth() {
        return this.wantClientAuth;
    }

    public void setWantClientAuth(boolean wantClientAuth) {
        this.wantClientAuth = wantClientAuth;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

