/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.components.jms;

import javax.jbi.JBIException;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkManager;
import javax.xml.transform.TransformerException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.components.jms.DestinationChooser;
import org.apache.servicemix.components.jms.JmsMarshaler;
import org.apache.servicemix.components.util.ComponentSupport;
import org.apache.servicemix.jbi.framework.ComponentContextImpl;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jms.JmsException;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.JmsTemplate102;
import org.springframework.jms.core.MessageCreator;

public class JmsServiceComponent
extends ComponentSupport
implements MessageListener,
InitializingBean,
DisposableBean {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$servicemix$components$jms$JmsServiceComponent == null ? (class$org$apache$servicemix$components$jms$JmsServiceComponent = JmsServiceComponent.class$("org.apache.servicemix.components.jms.JmsServiceComponent")) : class$org$apache$servicemix$components$jms$JmsServiceComponent));
    private DestinationChooser destinationChooser;
    private JmsMarshaler marshaler = new JmsMarshaler();
    private JmsTemplate template;
    private String selector;
    private MessageConsumer consumer;
    private ConnectionFactory connectionFactory;
    private Connection connection;
    private Session session;
    private WorkManager workManager;
    static /* synthetic */ Class class$org$apache$servicemix$components$jms$JmsServiceComponent;

    public void afterPropertiesSet() throws Exception {
        if (this.template == null) {
            throw new IllegalArgumentException("Must have a template set");
        }
        this.connectionFactory = this.template.getConnectionFactory();
        if (this.template instanceof JmsTemplate102) {
            if (this.template.isPubSubDomain()) {
                TopicConnection tc = ((TopicConnectionFactory)this.connectionFactory).createTopicConnection();
                this.connection = tc;
                this.session = tc.createTopicSession(this.template.isSessionTransacted(), this.template.getSessionAcknowledgeMode());
            } else {
                QueueConnection qc = ((QueueConnectionFactory)this.connectionFactory).createQueueConnection();
                this.connection = qc;
                this.session = qc.createQueueSession(this.template.isSessionTransacted(), this.template.getSessionAcknowledgeMode());
            }
        } else {
            this.connection = this.connectionFactory.createConnection();
            this.session = this.connection.createSession(this.template.isSessionTransacted(), this.template.getSessionAcknowledgeMode());
        }
        Destination defaultDestination = this.template.getDefaultDestination();
        if (defaultDestination == null) {
            defaultDestination = this.template.getDestinationResolver().resolveDestinationName(this.session, this.template.getDefaultDestinationName(), this.template.isPubSubDomain());
        }
        this.consumer = this.template instanceof JmsTemplate102 ? (this.template.isPubSubDomain() ? ((TopicSession)this.session).createSubscriber((Topic)defaultDestination, this.selector, this.template.isPubSubNoLocal()) : ((QueueSession)this.session).createReceiver((Queue)defaultDestination, this.selector)) : this.session.createConsumer(defaultDestination, this.selector);
        this.consumer.setMessageListener((MessageListener)this);
        this.connection.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws Exception {
        try {
            if (this.connection != null) {
                this.connection.close();
            } else if (this.session != null) {
                this.session.close();
            } else if (this.consumer != null) {
                this.consumer.close();
            }
        }
        finally {
            this.connection = null;
            this.session = null;
            this.consumer = null;
        }
    }

    protected void init() throws JBIException {
        if (this.workManager == null) {
            ComponentContextImpl context = (ComponentContextImpl)this.getContext();
            this.workManager = context.getWorkManager();
        }
        super.init();
    }

    public DestinationChooser getDestinationChooser() {
        return this.destinationChooser;
    }

    public void setDestinationChooser(DestinationChooser destinationChooser) {
        this.destinationChooser = destinationChooser;
    }

    public JmsMarshaler getMarshaler() {
        return this.marshaler;
    }

    public void setMarshaler(JmsMarshaler marshaler) {
        this.marshaler = marshaler;
    }

    public JmsTemplate getTemplate() {
        return this.template;
    }

    public void setTemplate(JmsTemplate template) {
        this.template = template;
    }

    public String getSelector() {
        return this.selector;
    }

    public void setSelector(String selector) {
        this.selector = selector;
    }

    public WorkManager getWorkManager() {
        return this.workManager;
    }

    public void setWorkManager(WorkManager workManager) {
        this.workManager = workManager;
    }

    public void onMessage(final Message jmsMessage) {
        try {
            this.workManager.scheduleWork(new Work(){

                public void release() {
                }

                public void run() {
                    JmsServiceComponent.this.handleMessage(jmsMessage);
                }
            });
        }
        catch (WorkException e) {
            log.error((Object)e);
        }
    }

    protected void handleMessage(final Message jmsMessage) {
        block6: {
            try {
                final InOut messageExchange = this.getDeliveryChannel().createExchangeFactory().createInOutExchange();
                NormalizedMessage inMessage = messageExchange.createMessage();
                try {
                    this.marshaler.toNMS(inMessage, jmsMessage);
                    messageExchange.setInMessage(inMessage);
                    if (!this.getDeliveryChannel().sendSync((MessageExchange)messageExchange)) break block6;
                    Destination destination = this.getReplyToDestination(jmsMessage, messageExchange);
                    try {
                        this.template.send(destination, new MessageCreator(){

                            public Message createMessage(Session session) throws JMSException {
                                try {
                                    Message message = JmsServiceComponent.this.marshaler.createMessage(messageExchange.getOutMessage(), session);
                                    message.setJMSCorrelationID(jmsMessage.getJMSCorrelationID());
                                    if (log.isTraceEnabled()) {
                                        log.trace((Object)("Sending message to: " + JmsServiceComponent.this.template.getDefaultDestinationName() + " message: " + message));
                                    }
                                    return message;
                                }
                                catch (TransformerException e) {
                                    JMSException jmsEx = new JMSException("Failed to create a JMS Message: " + e);
                                    jmsEx.setLinkedException((Exception)e);
                                    throw jmsEx;
                                }
                            }
                        });
                        this.done((MessageExchange)messageExchange);
                    }
                    catch (JmsException e) {
                        this.fail((MessageExchange)messageExchange, (Exception)((Object)e));
                    }
                }
                catch (JMSException e) {
                    log.error((Object)("Couldn't process " + jmsMessage), (Throwable)e);
                    messageExchange.setError((Exception)((Object)e));
                    messageExchange.setStatus(ExchangeStatus.ERROR);
                }
            }
            catch (MessagingException e) {
                log.error((Object)("Failed to process inbound JMS Message: " + jmsMessage), (Throwable)e);
            }
        }
    }

    protected Destination getReplyToDestination(Message jmsMessage, InOut messageExchange) throws JMSException {
        if (this.destinationChooser == null) {
            return jmsMessage.getJMSReplyTo();
        }
        return this.destinationChooser.chooseDestination((MessageExchange)messageExchange);
    }

    protected Destination chooseOutBoundDestination(MessageExchange exchange, Message inboundMessage) throws JMSException {
        Destination result = null;
        if (this.destinationChooser != null) {
            result = this.destinationChooser.chooseDestination(exchange);
        } else if (inboundMessage != null && inboundMessage.getJMSReplyTo() != null) {
            result = inboundMessage.getJMSReplyTo();
        }
        if (result == null) {
            log.error((Object)("Could not find an outbound destination for " + inboundMessage));
            throw new JMSException("No outbound JMS Destination can be found");
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

