/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.components.quartz;

import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import javax.jbi.JBIException;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.MessageExchangeListener;
import org.apache.servicemix.components.quartz.DefaultQuartzMarshaler;
import org.apache.servicemix.components.quartz.QuartzMarshaler;
import org.apache.servicemix.components.util.ComponentSupport;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerFactory;
import org.quartz.Trigger;
import org.quartz.impl.StdSchedulerFactory;

public class QuartzComponent
extends ComponentSupport
implements MessageExchangeListener {
    private static final transient Log log = LogFactory.getLog((Class)(class$org$apache$servicemix$components$quartz$QuartzComponent == null ? (class$org$apache$servicemix$components$quartz$QuartzComponent = QuartzComponent.class$("org.apache.servicemix.components.quartz.QuartzComponent")) : class$org$apache$servicemix$components$quartz$QuartzComponent));
    public static final String COMPONENT_KEY = "org.apache.servicemix.component";
    private SchedulerFactory factory;
    private Scheduler scheduler;
    private Map triggers;
    private QuartzMarshaler marshaler = new DefaultQuartzMarshaler();
    static /* synthetic */ Class class$org$apache$servicemix$components$quartz$QuartzComponent;
    static /* synthetic */ Class class$org$apache$servicemix$components$quartz$ServiceMixJob;

    public void start() throws JBIException {
        try {
            this.scheduler.resumeAll();
            super.start();
        }
        catch (SchedulerException e) {
            throw new JBIException((Throwable)e);
        }
    }

    public void stop() throws JBIException {
        try {
            super.stop();
            this.scheduler.pauseAll();
        }
        catch (SchedulerException e) {
            throw new JBIException((Throwable)e);
        }
    }

    public void shutDown() throws JBIException {
        try {
            this.scheduler.shutdown();
        }
        catch (SchedulerException e) {
            throw new JBIException((Throwable)e);
        }
        finally {
            super.shutDown();
        }
    }

    public void addTrigger(Trigger trigger, JobDetail detail) throws JBIException {
        try {
            if (trigger.getName() == null) {
                trigger.setName(detail.getName());
            }
            if (trigger.getGroup() == null) {
                trigger.setGroup(detail.getGroup());
            }
            if (trigger.getStartTime() == null) {
                trigger.setStartTime(new Date());
            }
            detail.getJobDataMap().put((Object)COMPONENT_KEY, (Object)this);
            Class jobClass = detail.getJobClass();
            if (jobClass == null) {
                detail.setJobClass(class$org$apache$servicemix$components$quartz$ServiceMixJob == null ? (class$org$apache$servicemix$components$quartz$ServiceMixJob = QuartzComponent.class$("org.apache.servicemix.components.quartz.ServiceMixJob")) : class$org$apache$servicemix$components$quartz$ServiceMixJob);
            }
            this.scheduler.scheduleJob(detail, trigger);
        }
        catch (SchedulerException e) {
            throw new JBIException("Failed to add trigger: " + trigger + " with detail: " + detail + ". Reason: " + (Object)((Object)e), (Throwable)e);
        }
    }

    public void onJobExecute(JobExecutionContext context) throws JobExecutionException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Firing Quartz Job with context: " + context));
        }
        try {
            InOnly exchange = this.getExchangeFactory().createInOnlyExchange();
            NormalizedMessage message = exchange.createMessage();
            this.getMarshaler().populateNormalizedMessage(message, context);
            exchange.setInMessage(message);
            this.send((MessageExchange)exchange);
        }
        catch (MessagingException e) {
            throw new JobExecutionException((Exception)((Object)e));
        }
    }

    public SchedulerFactory getFactory() {
        return this.factory;
    }

    public void setFactory(SchedulerFactory factory) {
        this.factory = factory;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public Map getTriggers() {
        return this.triggers;
    }

    public void setTriggers(Map triggers) {
        this.triggers = triggers;
    }

    public QuartzMarshaler getMarshaler() {
        return this.marshaler;
    }

    public void setMarshaler(QuartzMarshaler marshaler) {
        this.marshaler = marshaler;
    }

    protected void init() throws JBIException {
        super.init();
        try {
            if (this.scheduler == null) {
                if (this.factory == null) {
                    this.factory = new StdSchedulerFactory();
                }
                this.scheduler = this.factory.getScheduler();
                this.scheduler.pauseAll();
                this.scheduler.start();
            }
        }
        catch (SchedulerException e) {
            throw new JBIException((Throwable)e);
        }
        if (this.triggers != null) {
            Iterator iter = this.triggers.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                Object key = entry.getKey();
                Object value = entry.getValue();
                if (key == null) {
                    throw new IllegalArgumentException("Key of the map cannot be null");
                }
                if (value == null) {
                    throw new IllegalArgumentException("Key of the map cannot be null");
                }
                if (!(key instanceof Trigger)) {
                    throw new IllegalArgumentException("Key of the map must be a Trigger but was: " + key.getClass().getName());
                }
                if (!(value instanceof JobDetail)) {
                    throw new IllegalArgumentException("Key of the map must be a JobDetail but was: " + value.getClass().getName());
                }
                this.addTrigger((Trigger)key, (JobDetail)value);
            }
        }
    }

    public void onMessageExchange(MessageExchange exchange) throws MessagingException {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

